function [ v ] = gdl_first_v( mats, d, lambda1 )
%GDL the first step, compute the unnormalized vector field via heat flow
%
% Input:
%  - mats: the struct returned by gdl_MakeMats
%  - d: the dimension of the manifold
%  - lambda1: the parameter t in equation 5      
%
% Output:
%  - v: the initial vector field
%
% Example:
%   this function is not meant to be used explicitly, but it is used by GR.m

ip = inputParser;
ip.FunctionName = 'gdl_first_v';
ip.addRequired('mats', @isstruct);
ip.addRequired('d', @isnumeric);
ip.addRequired('lambda1', @isnumeric);

ip.parse(mats, d, lambda1);

% -- linear system
I = eye(size(mats.NCL));
Mtmp = I + lambda1 * mats.NCL;
V0 = mats.V0/1000;
v = linsolve(Mtmp,V0);

end

