'''
Author: Carl Yang
Function: Run the whole pipeline
Command: buck run @mode/dev-nosan //experimental/carlyang/place_embedding:main
'''
from __future__ import absolute_import, division, print_function, unicode_literals
from experimental.carlyang.place_embedding.config import args
from experimental.carlyang.place_embedding.eval import Evaluation
from experimental.carlyang.place_embedding.util import Dataset
from experimental.carlyang.place_embedding.embed import Embedding


if __name__ == '__main__':
    params = args

    dataset = Dataset(params)
    dataset.get_train()

    embed = Embedding(params)
    embed.train(dataset)

    if params.write_train:
        dataset.get_feat_train()
        dataset.write_embedding(embed.compute(dataset.feat_train))
    if params.write_test:
        dataset.get_test()
        eval = Evaluation(params)
        eval.evaluate(dataset, embed)
    if params.write_model:
        embed.store()
