import numpy as np
# from scipy.sparse import coo_matrix
import random
import cPickle as pickle
from sklearn.cluster import KMeans
from scipy.stats import multivariate_normal as mvn
from numpy.linalg import inv
from numpy.linalg import det


def gaussian(x, mean, cov):
    # print 'result = \n'
    # print np.dot((x - mean).transpose(), cov)
    return np.exp(np.dot(np.dot((x - mean).transpose(), cov), (x - mean)))


def GRWalk(Graphstring, circle, jump, move, jump_pro, start_index):
    f1 = open(Graphstring, 'r+')
    Graph = pickle.load(f1)
    aj = pickle.load(f1)
    f1.close()
    # print circle
    start = int(circle[start_index])
    path = [start]
    Energy = 1

    while Energy > 0:
        probability = random.uniform(0, 1)
        neighbor = list(set(aj[start]).intersection(set(circle[1:len(circle)])))
        if (probability <= jump_pro) or (len(neighbor) < 1):  # next step is jump
            next_index = random.randint(1, len(circle) - 1)  # circle[0] is the name of this circle
            next = int(circle[next_index])
        else:  # next step is move
            next_index = random.randint(0, len(neighbor) - 1)
            next = int(neighbor[next_index])
        if start != next:
            if Graph[start, next]:
                Energy = Energy - move
                # print 'move'
                path.append(next)
            else:
                Energy = Energy - jump
                # print 'jump'
                path.append(next)
            start = next

    if Energy < 0:
        path.pop()
    return path


def build(path, featstring, theta, s, beta, p1, p2, p3, maxiter, learningrate):
    f1 = open(featstring, 'r+')
    feat = pickle.load(f1)
    f1.close()
    feat = feat.astype(np.float64)
    feat_dim = feat.shape[1]
    # print feat_dim
    for iteration in range(1, maxiter+1):
        error = (feat[int(path[1])].reshape(feat_dim, 1) - np.dot(theta, s))
        for i in range(2, len(path)):
            error = error + (feat[int(path[i])].reshape(feat_dim, 1) - np.dot(theta, s))

        Grad_theta = np.dot(np.dot(beta, error), s.T) + p1 * theta
        Grad_s = np.dot(np.dot(theta.T, beta), error) + p2 * s
        Grad_beta = np.dot(error.T, error) + len(path) / 2 * inv(beta).transpose() + p3 * beta

        theta = theta + learningrate * Grad_theta
        s = s + learningrate * Grad_s
        beta = beta + learningrate * Grad_beta
        # if iteration % 100 == 0:
        #     print iteration
        #     print "_____________\n"
        #     print sum(error)
        # print det(beta)

    return (theta, s, beta)


def predict(path, featstring, theta, pattern, beta):
    f1 = open(featstring, 'r+')
    feat = pickle.load(f1)
    f1.close()
    feat = feat.astype(np.float64)
    feat_dim = feat.shape[1]
    pred = np.zeros([len(pattern), 1])

    for i in range(0, len(pattern)):
        pr = 1
        for node in path:
            pr = pr * gaussian(feat[int(node)].reshape(feat_dim, 1),
                               mean=np.dot(theta, pattern[i]).reshape(feat_dim, 1),
                               cov=beta)
            pred[i, 0] = pr

    return pred


f1 = open('community.pkl', 'r+')
community = pickle.load(f1)
f1.close()
circle = community[0]

f1 = open('feat.pkl', 'r+')
feat = pickle.load(f1)
feat = feat.astype(np.float64)
f1.close()

feat_dim = 224
topic_dim = 32

theta = np.random.random([feat_dim, topic_dim]) / topic_dim / feat_dim
beta = np.identity(feat_dim)
p1 = 0.1
p2 = 0.1
p3 = 0.01

pattern = np.zeros([23, topic_dim])
for k in range(0, 2):
    print k
    circle = community[k]
    s = np.random.random([topic_dim, 1])
    for i in range(0, len(circle)):
        path = GRWalk('Graph.pkl', circle, 0.5, 0.2, 0.3, random.randint(1, len(circle) - 1))
        # print path
        (theta, s, beta) = build(path, 'feat.pkl', theta, s, beta, p1, p2, p3, 400, -0.00001)
    pattern[k] = s.reshape(1, topic_dim)
    # print pattern[k]
    # print np.dot(theta, s)

print beta

test_graph = []
for k in range(10, 24):
    circle = community[k]
    test_graph = list(set(test_graph).union(set(circle[1:len(circle)])))

maxiter = 1
for i in range(0, maxiter):
    path = GRWalk('Graph.pkl', test_graph, 0.5, 0.2, 0.3, random.randint(1, len(circle) - 1))
    pred = predict(path, 'feat.pkl', theta, pattern, beta)
    print sum(np.dot(theta, pattern[0]) - feat[int(community[0][1])])
    # print pred
# clustering = KMeans(n_clusters=3, init='k-means++')

# clustering.fit(pattern)
# print clustering.labels_

# clustering.cluster_centers_
