import numpy as np
from scipy.sparse import lil_matrix, coo_matrix, csr_matrix, csc_matrix, diags, identity, linalg, hstack
from time import time
import math

n_user = 5200
n_feature = 9540
alpha = 0.8	#label propagation parameter
theta = 0.1	#label threshold parameter
#yita = 0.1	#graph learning rate
beta = 0.1	#graph regularization parameter

def filtered(f, theta):
	fmax = max(f)
	for i in range(len(f)):
		f[i] = f[i]/fmax
		if f[i] < theta:
			f[i] = 0
	return f

#initialize E0
t0 = time()
print("Input links... ")
file_link = "JUL_links.txt"
E0 = lil_matrix((n_user, n_user), dtype=np.float32)
with open(file_link) as f1:
	while 1:
		line = f1.readline()
		if not line:
			break
		ts = line.split("\t")
		E0[int(ts[0]), int(ts[1])] = 1
t1 = time()
print("done. Time elapsed "+str(t1-t0))

#initialize A0
t0 = time()
print("Input attributes... ")
file_attr = "JUL_features.txt"
A0 = lil_matrix((n_user, n_feature), dtype=np.float32)
with open(file_attr) as f2:
	while 1:
		line = f2.readline()
		if not line:
			break
		ts = line.split("\t")
		A0[int(ts[0]), abs(int(ts[1]))] = 1
t1 = time()
print("done. Time elapsed "+str(t1-t0))

#filter A0
t0 = time()
print("Filter rare attributes... ")
S0 = A0.sum(0)
A0 = A0.todense()
for i in range(S0.shape[1]):
	if S0[0, i] < 3:
		A0[:, i] = 0
A0 = lil_matrix(A0)
t1 = time()
print("done. Time elapsed "+str(t1-t0))

#begin iterations
Et = E0.tocsc()
for t in range(3):
	print("Iteration: "+str(t))
	#update At
	t0 = time()
	print("Updating attributes... ")
	D = diags(Et.sum(1).transpose().tolist()[0], 0).tocsc().sqrt()
	D = D._with_data(D.data ** -1)
	S = D*Et*D
	I = A0.sum(0).nonzero()[1].tolist()[0]
	At = A0.transpose()
	A_tmp = At.tocsr()
	for ind in I:
		y = A_tmp.getrow(ind)
		W = identity(n_user)-alpha*S
		f = linalg.spsolve(W, y)
		At[ind, :] = filtered(f, theta)
	At = At.transpose()
	t1 = time()
	print("done. Time elapsed "+str(t1-t0))

	#update Et
	t0 = time()
	print("Updating friendships... ")
	#At = A0.tocsc() #to be replaced
	At = At.tocsc()
	Es = E0.tocsc()
	Es = Es*Es
	Es.setdiag(Es.get_shape()[0]*[0])
	Es = Es.tolil()
	x = Es.nonzero()[0]
	y = Es.nonzero()[1]
	for ind in range(len(x)):
		Es[x[ind], y[ind]] = Es[x[ind], y[ind]]*math.exp(-1*sum((At[x[ind],:]-At[y[ind],:]).data**2))
	Et = (E0 + Es)/(2+beta)
	t1 = time()
	print("done. Time elapsed "+str(t1-t0))

#output predictions
t0 = time()
print("Writing the file... ")
file_pred = "BLA.txt"
list_pred = []
with open(file_pred, "w") as f3:
	ind = Et.nonzero()
	for i in range(len(ind[0])):
		if (E0[ind[0][i], ind[1][i]] == 0):
			list_pred.append([ind[0][i], ind[1][i], Et[ind[0][i], ind[1][i]]])
	list_pred = sorted(list_pred, key = lambda x: x[2], reverse = True)
	for k in range(len(list_pred)):
		f3.write(str(list_pred[k][0])+" "+str(list_pred[k][1])+" "+str(list_pred[k][2])+"\n")
t1 = time()
print("done. Time elapsed "+str(t1-t0))


