/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JFrame;

public class TTFTApplet
extends Applet
implements Runnable {
    private GraphicalTTFT gt;
    private TTFTAppletControls controls;
    private Thread doer;

    @Override
    public void init() {
        this.gt = new GraphicalTTFT(this, new Font("Serif", 0, 10), Color.black, Color.white, Color.red, 2, this.getSize().width / 2);
        this.setBackground(Color.lightGray);
        this.controls = new TTFTAppletControls(this, this.gt);
        this.setLayout(new BorderLayout());
        this.add((Component)this.controls, "South");
        this.doer = new Thread(this);
        this.doer.start();
    }

    public void resize() {
        this.gt.resize(this.getSize().width / 2);
    }

    @Override
    public void destroy() {
        this.remove(this.controls);
        this.doer = null;
    }

    @Override
    public void start() {
        this.controls.setEnabled(true);
    }

    @Override
    public void stop() {
        this.controls.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        while (thread == this.doer) {
            try {
                GraphicalTTFT graphicalTTFT = this.gt;
                synchronized (graphicalTTFT) {
                    this.gt.wait();
                }
                this.gt.Perform();
                this.repaint();
                this.controls.setEnabled(true);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (TTFTException tTFTException) {
                this.gt.setInfo("Exception (see console): " + tTFTException.getMessage());
                this.repaint();
                tTFTException.printStackTrace();
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        this.gt.Draw(graphics);
    }

    @Override
    public String getAppletInfo() {
        return "Title: A Graphical 2-3-4 Tree\nAuthor: Rory McGuire, rlpm@unm.edu 2004";
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("2-3-4 Tree");
        TTFTApplet tTFTApplet = new TTFTApplet();
        jFrame.setSize(800, 200);
        tTFTApplet.setSize(800, 200);
        jFrame.getContentPane().add("Center", tTFTApplet);
        jFrame.setDefaultCloseOperation(3);
        tTFTApplet.init();
        tTFTApplet.start();
        jFrame.show();
    }
}

