/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;

public class GraphicalTTFT
extends TTFT {
    private TTFTApplet ttfta;
    private Font font;
    private FontMetrics metrics;
    private Color nodeOlColor;
    private Color nodeBgColor;
    private Color nodeHighColor;
    private int nodeBorder;
    private int nodeHeight;
    private Point startPt;
    private int lineY;
    private String info;
    private Point infopt;
    private int sleepy;
    private GTAction gta;

    public GraphicalTTFT(TTFTApplet a, Font fnt, Color nodeOl, Color nodeBg, Color nodeHigh, int border, int startx) {
        this.ttfta = a;
        this.font = fnt;
        this.metrics = a.getFontMetrics(this.font);
        this.nodeOlColor = nodeOl;
        this.nodeBgColor = nodeBg;
        this.nodeHighColor = nodeHigh;
        this.nodeBorder = border;
        this.nodeHeight = this.metrics.getHeight() + this.nodeBorder * 2;
        this.startPt = new Point(startx, this.nodeHeight / 2 + this.nodeBorder);
        this.lineY = this.nodeHeight + this.nodeBorder * 2;
        this.info = new String();
        this.infopt = new Point(this.nodeBorder, this.metrics.getAscent());
        this.sleepy = 1000;
    }

    public void resize(int startx) {
        this.startPt.x = startx;
    }

    public synchronized void slowest() {
        this.sleepy = 1900;
        this.speedinfo();
    }

    public synchronized void fastest() {
        this.sleepy = 0;
        this.speedinfo();
    }

    public synchronized void slower() {
        if (this.sleepy < 1900) {
            this.sleepy += 100;
        }
        this.speedinfo();
    }

    public synchronized void faster() {
        if (this.sleepy > 0) {
            this.sleepy -= 100;
        }
        this.speedinfo();
    }

    @Override
    public synchronized void Reset() {
        super.Reset();
        this.info = "Tree reset!";
    }

    @Override
    public synchronized boolean Insert(int what) throws TTFTException {
        boolean ret = true;
        boolean ff = this.FindFirst();
        this.FindFirst(false);
        if (ff) {
            this.info = "Finding first: " + what;
            if (super.Find(what)) {
                ret = false;
            }
        }
        if (ret) {
            this.info = "Inserting: " + what;
            ret = super.Insert(what);
            if (ret) {
                this.info = "Inserted: " + what;
            }
        }
        if (!ret) {
            this.info = "Value: " + what + " already in tree!";
        }
        this.FindFirst(ff);
        return ret;
    }

    public synchronized int getRandom(boolean intree) {
        int i;
        int ret = (int)(Math.random() * 100.0);
        int prevsleepy = this.sleepy;
        this.sleepy = 0;
        for (i = 0; i < 100 && intree != super.Find(ret); ++i) {
            ret = (ret + 13) % 100;
        }
        if (i == 100) {
            ret = -1;
        }
        this.sleepy = prevsleepy;
        return ret;
    }

    @Override
    public synchronized boolean Find(int what) {
        this.info = "Finding: " + what;
        boolean ret = super.Find(what);
        String after = "Value: " + what + " ";
        if (!ret) {
            after = after + "not ";
        }
        this.info = after = after + "found!";
        return ret;
    }

    @Override
    public synchronized boolean Delete(int what) throws TTFTException {
        boolean ret = true;
        boolean ff = this.FindFirst();
        this.FindFirst(false);
        if (ff) {
            this.info = "Finding first: " + what;
            if (!super.Find(what)) {
                ret = false;
            }
        }
        if (ret) {
            this.info = "Deleting: " + what;
            ret = super.Delete(what);
            if (ret) {
                this.info = "Deleted: " + what;
            }
        }
        if (!ret) {
            this.info = "Value: " + what + " not in tree!";
        }
        this.FindFirst(ff);
        return ret;
    }

    private void speedinfo() {
        this.info = "Speed: " + (2000 - this.sleepy) / 20 + "%";
    }

    @Override
    protected synchronized void sleepytime() {
        if (this.sleepy != 0) {
            this.ttfta.repaint();
            try {
                this.wait(this.sleepy);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void setInfo(String s) {
        this.info = s;
    }

    public synchronized void Draw(Graphics g) {
        ((GNode)this.root).drawNode(this.startPt, g);
        g.drawString(this.info, this.infopt.x, this.infopt.y);
    }

    public synchronized void Request(GTAction act) {
        this.gta = act;
        this.notify();
    }

    public synchronized void Perform() throws TTFTException {
        if (this.gta.action == GTAction.INSERT) {
            this.Insert(this.gta.data);
        } else if (this.gta.action == GTAction.FIND) {
            this.Find(this.gta.data);
        } else if (this.gta.action == GTAction.DELETE) {
            this.Delete(this.gta.data);
        } else {
            throw new TTFTException("do not know action: " + this.gta.action);
        }
        this.gta = null;
    }

    @Override
    public synchronized void SplitOnTheWayDown(boolean torf) {
        super.SplitOnTheWayDown(torf);
    }

    @Override
    public synchronized void FindFirst(boolean torf) {
        super.FindFirst(torf);
    }

    @Override
    protected TTFT.Node CreateNode() {
        return new GNode();
    }

    private class GNode
    extends TTFT.Node {
        private GNode() {
        }

        private int getWidth(Graphics g) {
            if (this.children[0] != null) {
                int width = GraphicalTTFT.this.nodeBorder;
                for (int i = 0; i <= this.numvals; ++i) {
                    width += ((GNode)this.children[i]).getWidth(g) + GraphicalTTFT.this.nodeBorder;
                }
                return width;
            }
            return this.myWidth();
        }

        private int myWidth() {
            int width = GraphicalTTFT.this.nodeBorder;
            for (int i = 0; i < this.numvals; ++i) {
                width += GraphicalTTFT.this.metrics.stringWidth(Integer.toString(this.vals[i]));
            }
            return width += GraphicalTTFT.this.nodeBorder * this.numvals;
        }

        private void drawNode(Point center, Graphics g) {
            Point where = new Point(center);
            g.setFont(GraphicalTTFT.this.font);
            int width = this.myWidth();
            where.x -= width / 2;
            where.y -= GraphicalTTFT.this.nodeHeight / 2;
            if (this.high) {
                g.setColor(GraphicalTTFT.this.nodeHighColor);
            } else {
                g.setColor(GraphicalTTFT.this.nodeBgColor);
            }
            if (this.numvals == 0) {
                width += 2 * GraphicalTTFT.this.nodeBorder;
            }
            g.fillRoundRect(where.x, where.y, width + 1, GraphicalTTFT.this.nodeHeight + 1, 5, 5);
            g.setColor(GraphicalTTFT.this.nodeOlColor);
            g.drawRoundRect(where.x, where.y, width, GraphicalTTFT.this.nodeHeight, 5, 5);
            where.y += GraphicalTTFT.this.nodeBorder + GraphicalTTFT.this.metrics.getAscent();
            where.x += GraphicalTTFT.this.nodeBorder + 1;
            String[] valss = new String[this.numvals];
            int[] valsw = new int[this.numvals];
            for (int i = 0; i < this.numvals; ++i) {
                valss[i] = Integer.toString(this.vals[i]);
                g.drawString(valss[i], where.x, where.y);
                valsw[i] = GraphicalTTFT.this.nodeBorder + GraphicalTTFT.this.metrics.stringWidth(valss[i]);
                where.x += valsw[i];
            }
            if (this.children[0] != null) {
                int i;
                int[] cw = new int[this.numvals + 1];
                int tw = 0;
                for (int i2 = 0; i2 <= this.numvals; ++i2) {
                    cw[i2] = ((GNode)this.children[i2]).getWidth(g);
                    tw += cw[i2];
                }
                Point cc = new Point(center.x - tw / 2, center.y + GraphicalTTFT.this.lineY);
                Point st = new Point(center.x - this.myWidth() / 2 + GraphicalTTFT.this.nodeBorder / 2, center.y + GraphicalTTFT.this.nodeHeight / 2);
                for (i = 0; i < this.numvals; ++i) {
                    cc.x += cw[i] / 2;
                    g.drawLine(st.x, st.y, cc.x, cc.y - GraphicalTTFT.this.nodeHeight / 2);
                    ((GNode)this.children[i]).drawNode(cc, g);
                    cc.x += cw[i] / 2;
                    cc.x += GraphicalTTFT.this.nodeBorder;
                    st.x += valsw[i] + GraphicalTTFT.this.nodeBorder / 2;
                }
                cc.x += cw[i] / 2;
                if (this.numvals == 0) {
                    st.x = center.x;
                } else {
                    --st.x;
                    --st.y;
                }
                g.drawLine(st.x, st.y, cc.x, cc.y - GraphicalTTFT.this.nodeHeight / 2);
                ((GNode)this.children[i]).drawNode(cc, g);
            }
        }
    }
}

