/*
 * Decompiled with CFR 0.152.
 */
public class StdStats {
    public static double max(double[] dArray) {
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public static double max(double[] dArray, int n, int n2) {
        if (n < 0 || n2 >= dArray.length || n > n2) {
            throw new RuntimeException("Subarray indices out of bounds");
        }
        double d = Double.NEGATIVE_INFINITY;
        for (int i = n; i <= n2; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public static int max(int[] nArray) {
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public static double min(double[] dArray) {
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] < d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public static double min(double[] dArray, int n, int n2) {
        if (n < 0 || n2 >= dArray.length || n > n2) {
            throw new RuntimeException("Subarray indices out of bounds");
        }
        double d = Double.POSITIVE_INFINITY;
        for (int i = n; i <= n2; ++i) {
            if (!(dArray[i] < d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public static int min(int[] nArray) {
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public static double mean(double[] dArray) {
        if (dArray.length == 0) {
            return Double.NaN;
        }
        double d = StdStats.sum(dArray);
        return d / (double)dArray.length;
    }

    public static double mean(double[] dArray, int n, int n2) {
        int n3 = n2 - n + 1;
        if (n < 0 || n2 >= dArray.length || n > n2) {
            throw new RuntimeException("Subarray indices out of bounds");
        }
        if (n3 == 0) {
            return Double.NaN;
        }
        double d = StdStats.sum(dArray, n, n2);
        return d / (double)n3;
    }

    public static double mean(int[] nArray) {
        if (nArray.length == 0) {
            return Double.NaN;
        }
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += (double)nArray[i];
        }
        return d / (double)nArray.length;
    }

    public static double var(double[] dArray) {
        if (dArray.length == 0) {
            return Double.NaN;
        }
        double d = StdStats.mean(dArray);
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += (dArray[i] - d) * (dArray[i] - d);
        }
        return d2 / (double)(dArray.length - 1);
    }

    public static double var(double[] dArray, int n, int n2) {
        int n3 = n2 - n + 1;
        if (n < 0 || n2 >= dArray.length || n > n2) {
            throw new RuntimeException("Subarray indices out of bounds");
        }
        if (n3 == 0) {
            return Double.NaN;
        }
        double d = StdStats.mean(dArray, n, n2);
        double d2 = 0.0;
        for (int i = n; i <= n2; ++i) {
            d2 += (dArray[i] - d) * (dArray[i] - d);
        }
        return d2 / (double)(n3 - 1);
    }

    public static double var(int[] nArray) {
        if (nArray.length == 0) {
            return Double.NaN;
        }
        double d = StdStats.mean(nArray);
        double d2 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d2 += ((double)nArray[i] - d) * ((double)nArray[i] - d);
        }
        return d2 / (double)(nArray.length - 1);
    }

    public static double varp(double[] dArray) {
        if (dArray.length == 0) {
            return Double.NaN;
        }
        double d = StdStats.mean(dArray);
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += (dArray[i] - d) * (dArray[i] - d);
        }
        return d2 / (double)dArray.length;
    }

    public static double varp(double[] dArray, int n, int n2) {
        int n3 = n2 - n + 1;
        if (n < 0 || n2 >= dArray.length || n > n2) {
            throw new RuntimeException("Subarray indices out of bounds");
        }
        if (n3 == 0) {
            return Double.NaN;
        }
        double d = StdStats.mean(dArray, n, n2);
        double d2 = 0.0;
        for (int i = n; i <= n2; ++i) {
            d2 += (dArray[i] - d) * (dArray[i] - d);
        }
        return d2 / (double)n3;
    }

    public static double stddev(double[] dArray) {
        return Math.sqrt(StdStats.var(dArray));
    }

    public static double stddev(double[] dArray, int n, int n2) {
        return Math.sqrt(StdStats.var(dArray, n, n2));
    }

    public static double stddev(int[] nArray) {
        return Math.sqrt(StdStats.var(nArray));
    }

    public static double stddevp(double[] dArray) {
        return Math.sqrt(StdStats.varp(dArray));
    }

    public static double stddevp(double[] dArray, int n, int n2) {
        return Math.sqrt(StdStats.varp(dArray, n, n2));
    }

    public static double sum(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static double sum(double[] dArray, int n, int n2) {
        int n3 = n2 - n + 1;
        if (n < 0 || n2 >= dArray.length || n > n2) {
            throw new RuntimeException("Subarray indices out of bounds");
        }
        double d = 0.0;
        for (int i = n; i <= n2; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static int sum(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    public static void plotPoints(double[] dArray) {
        int n = dArray.length;
        StdDraw.setXscale(0.0, n - 1);
        StdDraw.setPenRadius(1.0 / (3.0 * (double)n));
        for (int i = 0; i < n; ++i) {
            StdDraw.point(i, dArray[i]);
        }
    }

    public static void plotLines(double[] dArray) {
        int n = dArray.length;
        StdDraw.setXscale(0.0, n - 1);
        StdDraw.setPenRadius();
        for (int i = 1; i < n; ++i) {
            StdDraw.line(i - 1, dArray[i - 1], i, dArray[i]);
        }
    }

    public static void plotBars(double[] dArray) {
        int n = dArray.length;
        StdDraw.setXscale(0.0, n - 1);
        StdDraw.setPenRadius(0.5 / (double)n);
        for (int i = 0; i < n; ++i) {
            StdDraw.filledRectangle(i, dArray[i] / 2.0, 0.25, dArray[i] / 2.0);
        }
    }

    public static void main(String[] stringArray) {
        double[] dArray = StdArrayIO.readDouble1D();
        StdOut.printf("       min %7.3f\n", StdStats.min(dArray));
        StdOut.printf("      mean %7.3f\n", StdStats.mean(dArray));
        StdOut.printf("       max %7.3f\n", StdStats.max(dArray));
        StdOut.printf("   std dev %7.3f\n", StdStats.stddev(dArray));
    }
}

