/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class StdRandom {
    private static Random random = new Random();

    public static void setSeed(long l) {
        random = new Random(l);
    }

    public static double uniform() {
        return random.nextDouble();
    }

    public static double random() {
        return random.nextDouble();
    }

    public static int uniform(int n) {
        return random.nextInt(n);
    }

    public static int uniform(int n, int n2) {
        return n + StdRandom.uniform(n2 - n);
    }

    public static double uniform(double d, double d2) {
        return d + StdRandom.uniform() * (d2 - d);
    }

    public static boolean bernoulli(double d) {
        return StdRandom.uniform() < d;
    }

    public static boolean bernoulli() {
        return StdRandom.bernoulli(0.5);
    }

    public static double gaussian() {
        double d;
        double d2;
        double d3;
        while ((d3 = (d2 = StdRandom.uniform(-1.0, 1.0)) * d2 + (d = StdRandom.uniform(-1.0, 1.0)) * d) >= 1.0 || d3 == 0.0) {
        }
        return d2 * Math.sqrt(-2.0 * Math.log(d3) / d3);
    }

    public static double gaussian(double d, double d2) {
        return d + d2 * StdRandom.gaussian();
    }

    public static int geometric(double d) {
        return (int)Math.ceil(Math.log(StdRandom.uniform()) / Math.log(1.0 - d));
    }

    public static int poisson(double d) {
        int n = 0;
        double d2 = 1.0;
        double d3 = Math.exp(-d);
        do {
            ++n;
        } while ((d2 *= StdRandom.uniform()) >= d3);
        return n - 1;
    }

    public static double pareto(double d) {
        return Math.pow(1.0 - StdRandom.uniform(), -1.0 / d) - 1.0;
    }

    public static double cauchy() {
        return Math.tan(Math.PI * (StdRandom.uniform() - 0.5));
    }

    public static int discrete(double[] dArray) {
        double d = StdRandom.uniform();
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!((d2 += dArray[i]) >= d)) continue;
            return i;
        }
        assert (false);
        return -1;
    }

    public static double exp(double d) {
        return -Math.log(1.0 - Math.random()) / d;
    }

    private static void exch(String[] stringArray, int n, int n2) {
        String string = stringArray[n];
        stringArray[n] = stringArray[n2];
        stringArray[n2] = string;
    }

    public static void shuffle(Object[] objectArray) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i + StdRandom.uniform(n - i);
            Object object = objectArray[i];
            objectArray[i] = objectArray[n2];
            objectArray[n2] = object;
        }
    }

    public static void shuffle(double[] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i + StdRandom.uniform(n - i);
            double d = dArray[i];
            dArray[i] = dArray[n2];
            dArray[n2] = d;
        }
    }

    public static void shuffle(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i + StdRandom.uniform(n - i);
            int n3 = nArray[i];
            nArray[i] = nArray[n2];
            nArray[n2] = n3;
        }
    }

    public static void shuffle(Object[] objectArray, int n, int n2) {
        if (n < 0 || n > n2 || n2 >= objectArray.length) {
            throw new RuntimeException("Illegal subarray range");
        }
        for (int i = n; i <= n2; ++i) {
            int n3 = i + StdRandom.uniform(n2 - i + 1);
            Object object = objectArray[i];
            objectArray[i] = objectArray[n3];
            objectArray[n3] = object;
        }
    }

    public static void shuffle(double[] dArray, int n, int n2) {
        if (n < 0 || n > n2 || n2 >= dArray.length) {
            throw new RuntimeException("Illegal subarray range");
        }
        for (int i = n; i <= n2; ++i) {
            int n3 = i + StdRandom.uniform(n2 - i + 1);
            double d = dArray[i];
            dArray[i] = dArray[n3];
            dArray[n3] = d;
        }
    }

    public static void shuffle(int[] nArray, int n, int n2) {
        if (n < 0 || n > n2 || n2 >= nArray.length) {
            throw new RuntimeException("Illegal subarray range");
        }
        for (int i = n; i <= n2; ++i) {
            int n3 = i + StdRandom.uniform(n2 - i + 1);
            int n4 = nArray[i];
            nArray[i] = nArray[n3];
            nArray[n3] = n4;
        }
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        if (stringArray.length == 2) {
            StdRandom.setSeed(Long.parseLong(stringArray[1]));
        }
        double[] dArray = new double[]{0.5, 0.3, 0.1, 0.1};
        for (int i = 0; i < n; ++i) {
            StdOut.printf("%2d ", StdRandom.uniform(100));
            StdOut.printf("%8.5f ", StdRandom.uniform(10.0, 99.0));
            StdOut.printf("%5b ", StdRandom.bernoulli(0.5));
            StdOut.printf("%7.5f ", StdRandom.gaussian(9.0, 0.2));
            StdOut.printf("%2d ", StdRandom.discrete(dArray));
            StdOut.println();
        }
    }
}

