/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.InputMismatchException;
import java.util.Locale;
import java.util.Scanner;

public final class StdIn {
    private static String charsetName = "UTF-8";
    private static Locale usLocale = new Locale("en", "US");
    private static Scanner scanner = new Scanner((InputStream)new BufferedInputStream(System.in), charsetName);

    private StdIn() {
    }

    public static boolean isEmpty() {
        return !scanner.hasNext();
    }

    public static String readString() {
        return scanner.next();
    }

    public static int readInt() {
        return scanner.nextInt();
    }

    public static double readDouble() {
        return scanner.nextDouble();
    }

    public static float readFloat() {
        return scanner.nextFloat();
    }

    public static short readShort() {
        return scanner.nextShort();
    }

    public static long readLong() {
        return scanner.nextLong();
    }

    public static byte readByte() {
        return scanner.nextByte();
    }

    public static boolean readBoolean() {
        String string = StdIn.readString();
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        if (string.equals("1")) {
            return true;
        }
        if (string.equals("0")) {
            return false;
        }
        throw new InputMismatchException();
    }

    public static boolean hasNextLine() {
        return scanner.hasNextLine();
    }

    public static String readLine() {
        return scanner.nextLine();
    }

    public static char readChar() {
        String string = scanner.findWithinHorizon("(?s).", 1);
        return string.charAt(0);
    }

    public static String readAll() {
        if (!scanner.hasNextLine()) {
            return null;
        }
        return scanner.useDelimiter("\\A").next();
    }

    public static int[] readInts() {
        String[] stringArray = StdIn.readAll().trim().split("\\s+");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    public static double[] readDoubles() {
        String[] stringArray = StdIn.readAll().trim().split("\\s+");
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dArray[i] = Double.parseDouble(stringArray[i]);
        }
        return dArray;
    }

    public static String[] readStrings() {
        String[] stringArray = StdIn.readAll().trim().split("\\s+");
        return stringArray;
    }

    public static void main(String[] stringArray) {
        System.out.println("Type a string: ");
        String string = StdIn.readString();
        System.out.println("Your string was: " + string);
        System.out.println();
        System.out.println("Type an int: ");
        int n = StdIn.readInt();
        System.out.println("Your int was: " + n);
        System.out.println();
        System.out.println("Type a boolean: ");
        boolean bl = StdIn.readBoolean();
        System.out.println("Your boolean was: " + bl);
        System.out.println();
        System.out.println("Type a double: ");
        double d = StdIn.readDouble();
        System.out.println("Your double was: " + d);
        System.out.println();
    }

    static {
        scanner.useLocale(usLocale);
    }
}

