/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public final class StdDraw
implements ActionListener,
MouseListener,
MouseMotionListener,
KeyListener {
    public static final Color BLACK = Color.BLACK;
    public static final Color BLUE = Color.BLUE;
    public static final Color CYAN = Color.CYAN;
    public static final Color DARK_GRAY = Color.DARK_GRAY;
    public static final Color GRAY = Color.GRAY;
    public static final Color GREEN = Color.GREEN;
    public static final Color LIGHT_GRAY = Color.LIGHT_GRAY;
    public static final Color MAGENTA = Color.MAGENTA;
    public static final Color ORANGE = Color.ORANGE;
    public static final Color PINK = Color.PINK;
    public static final Color RED = Color.RED;
    public static final Color WHITE = Color.WHITE;
    public static final Color YELLOW = Color.YELLOW;
    public static final Color BOOK_BLUE = new Color(9, 90, 166);
    public static final Color BOOK_LIGHT_BLUE = new Color(103, 198, 243);
    public static final Color BOOK_RED = new Color(150, 35, 31);
    private static final Color DEFAULT_PEN_COLOR = BLACK;
    private static final Color DEFAULT_CLEAR_COLOR = WHITE;
    private static Color penColor;
    private static final int DEFAULT_SIZE = 512;
    private static int width;
    private static int height;
    private static final double DEFAULT_PEN_RADIUS = 0.002;
    private static double penRadius;
    private static boolean defer;
    private static final double BORDER = 0.05;
    private static final double DEFAULT_XMIN = 0.0;
    private static final double DEFAULT_XMAX = 1.0;
    private static final double DEFAULT_YMIN = 0.0;
    private static final double DEFAULT_YMAX = 1.0;
    private static double xmin;
    private static double ymin;
    private static double xmax;
    private static double ymax;
    private static Object mouseLock;
    private static Object keyLock;
    private static final Font DEFAULT_FONT;
    private static Font font;
    private static BufferedImage offscreenImage;
    private static BufferedImage onscreenImage;
    private static Graphics2D offscreen;
    private static Graphics2D onscreen;
    private static StdDraw std;
    private static JFrame frame;
    private static boolean mousePressed;
    private static double mouseX;
    private static double mouseY;
    private static LinkedList<Character> keysTyped;
    private static TreeSet<Character> keysDown;

    private StdDraw() {
    }

    public static void setCanvasSize() {
        StdDraw.setCanvasSize(512, 512);
    }

    public static void setCanvasSize(int n, int n2) {
        if (n < 1 || n2 < 1) {
            throw new RuntimeException("width and height must be positive");
        }
        width = n;
        height = n2;
        StdDraw.init();
    }

    private static void init() {
        if (frame != null) {
            frame.setVisible(false);
        }
        frame = new JFrame();
        offscreenImage = new BufferedImage(width, height, 2);
        onscreenImage = new BufferedImage(width, height, 2);
        offscreen = offscreenImage.createGraphics();
        onscreen = onscreenImage.createGraphics();
        StdDraw.setXscale();
        StdDraw.setYscale();
        offscreen.setColor(DEFAULT_CLEAR_COLOR);
        offscreen.fillRect(0, 0, width, height);
        StdDraw.setPenColor();
        StdDraw.setPenRadius();
        StdDraw.setFont();
        StdDraw.clear();
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        offscreen.addRenderingHints(renderingHints);
        ImageIcon imageIcon = new ImageIcon(onscreenImage);
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.addMouseListener(std);
        jLabel.addMouseMotionListener(std);
        frame.setContentPane(jLabel);
        frame.addKeyListener(std);
        frame.setResizable(false);
        frame.setDefaultCloseOperation(3);
        frame.setTitle("Standard Draw");
        frame.setJMenuBar(StdDraw.createMenuBar());
        frame.pack();
        frame.requestFocusInWindow();
        frame.setVisible(true);
    }

    private static JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(" Save...   ");
        jMenuItem.addActionListener(std);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.add(jMenuItem);
        return jMenuBar;
    }

    public static void setXscale() {
        StdDraw.setXscale(0.0, 1.0);
    }

    public static void setYscale() {
        StdDraw.setYscale(0.0, 1.0);
    }

    public static void setXscale(double d, double d2) {
        double d3 = d2 - d;
        xmin = d - 0.05 * d3;
        xmax = d2 + 0.05 * d3;
    }

    public static void setYscale(double d, double d2) {
        double d3 = d2 - d;
        ymin = d - 0.05 * d3;
        ymax = d2 + 0.05 * d3;
    }

    private static double scaleX(double d) {
        return (double)width * (d - xmin) / (xmax - xmin);
    }

    private static double scaleY(double d) {
        return (double)height * (ymax - d) / (ymax - ymin);
    }

    private static double factorX(double d) {
        return d * (double)width / Math.abs(xmax - xmin);
    }

    private static double factorY(double d) {
        return d * (double)height / Math.abs(ymax - ymin);
    }

    private static double userX(double d) {
        return xmin + d * (xmax - xmin) / (double)width;
    }

    private static double userY(double d) {
        return ymax - d * (ymax - ymin) / (double)height;
    }

    public static void clear() {
        StdDraw.clear(DEFAULT_CLEAR_COLOR);
    }

    public static void clear(Color color) {
        offscreen.setColor(color);
        offscreen.fillRect(0, 0, width, height);
        offscreen.setColor(penColor);
        StdDraw.draw();
    }

    public static double getPenRadius() {
        return penRadius;
    }

    public static void setPenRadius() {
        StdDraw.setPenRadius(0.002);
    }

    public static void setPenRadius(double d) {
        if (d < 0.0) {
            throw new RuntimeException("pen radius must be positive");
        }
        penRadius = d * 512.0;
        BasicStroke basicStroke = new BasicStroke((float)penRadius, 1, 1);
        offscreen.setStroke(basicStroke);
    }

    public static Color getPenColor() {
        return penColor;
    }

    public static void setPenColor() {
        StdDraw.setPenColor(DEFAULT_PEN_COLOR);
    }

    public static void setPenColor(Color color) {
        penColor = color;
        offscreen.setColor(penColor);
    }

    public static Font getFont() {
        return font;
    }

    public static void setFont() {
        StdDraw.setFont(DEFAULT_FONT);
    }

    public static void setFont(Font font) {
        StdDraw.font = font;
    }

    public static void line(double d, double d2, double d3, double d4) {
        offscreen.draw(new Line2D.Double(StdDraw.scaleX(d), StdDraw.scaleY(d2), StdDraw.scaleX(d3), StdDraw.scaleY(d4)));
        StdDraw.draw();
    }

    private static void pixel(double d, double d2) {
        offscreen.fillRect((int)Math.round(StdDraw.scaleX(d)), (int)Math.round(StdDraw.scaleY(d2)), 1, 1);
    }

    public static void point(double d, double d2) {
        double d3 = StdDraw.scaleX(d);
        double d4 = StdDraw.scaleY(d2);
        double d5 = penRadius;
        if (d5 <= 1.0) {
            StdDraw.pixel(d, d2);
        } else {
            offscreen.fill(new Ellipse2D.Double(d3 - d5 / 2.0, d4 - d5 / 2.0, d5, d5));
        }
        StdDraw.draw();
    }

    public static void circle(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new RuntimeException("circle radius can't be negative");
        }
        double d4 = StdDraw.scaleX(d);
        double d5 = StdDraw.scaleY(d2);
        double d6 = StdDraw.factorX(2.0 * d3);
        double d7 = StdDraw.factorY(2.0 * d3);
        if (d6 <= 1.0 && d7 <= 1.0) {
            StdDraw.pixel(d, d2);
        } else {
            offscreen.draw(new Ellipse2D.Double(d4 - d6 / 2.0, d5 - d7 / 2.0, d6, d7));
        }
        StdDraw.draw();
    }

    public static void filledCircle(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new RuntimeException("circle radius can't be negative");
        }
        double d4 = StdDraw.scaleX(d);
        double d5 = StdDraw.scaleY(d2);
        double d6 = StdDraw.factorX(2.0 * d3);
        double d7 = StdDraw.factorY(2.0 * d3);
        if (d6 <= 1.0 && d7 <= 1.0) {
            StdDraw.pixel(d, d2);
        } else {
            offscreen.fill(new Ellipse2D.Double(d4 - d6 / 2.0, d5 - d7 / 2.0, d6, d7));
        }
        StdDraw.draw();
    }

    public static void ellipse(double d, double d2, double d3, double d4) {
        if (d3 < 0.0) {
            throw new RuntimeException("ellipse semimajor axis can't be negative");
        }
        if (d4 < 0.0) {
            throw new RuntimeException("ellipse semiminor axis can't be negative");
        }
        double d5 = StdDraw.scaleX(d);
        double d6 = StdDraw.scaleY(d2);
        double d7 = StdDraw.factorX(2.0 * d3);
        double d8 = StdDraw.factorY(2.0 * d4);
        if (d7 <= 1.0 && d8 <= 1.0) {
            StdDraw.pixel(d, d2);
        } else {
            offscreen.draw(new Ellipse2D.Double(d5 - d7 / 2.0, d6 - d8 / 2.0, d7, d8));
        }
        StdDraw.draw();
    }

    public static void filledEllipse(double d, double d2, double d3, double d4) {
        if (d3 < 0.0) {
            throw new RuntimeException("ellipse semimajor axis can't be negative");
        }
        if (d4 < 0.0) {
            throw new RuntimeException("ellipse semiminor axis can't be negative");
        }
        double d5 = StdDraw.scaleX(d);
        double d6 = StdDraw.scaleY(d2);
        double d7 = StdDraw.factorX(2.0 * d3);
        double d8 = StdDraw.factorY(2.0 * d4);
        if (d7 <= 1.0 && d8 <= 1.0) {
            StdDraw.pixel(d, d2);
        } else {
            offscreen.fill(new Ellipse2D.Double(d5 - d7 / 2.0, d6 - d8 / 2.0, d7, d8));
        }
        StdDraw.draw();
    }

    public static void arc(double d, double d2, double d3, double d4, double d5) {
        if (d3 < 0.0) {
            throw new RuntimeException("arc radius can't be negative");
        }
        while (d5 < d4) {
            d5 += 360.0;
        }
        double d6 = StdDraw.scaleX(d);
        double d7 = StdDraw.scaleY(d2);
        double d8 = StdDraw.factorX(2.0 * d3);
        double d9 = StdDraw.factorY(2.0 * d3);
        if (d8 <= 1.0 && d9 <= 1.0) {
            StdDraw.pixel(d, d2);
        } else {
            offscreen.draw(new Arc2D.Double(d6 - d8 / 2.0, d7 - d9 / 2.0, d8, d9, d4, d5 - d4, 0));
        }
        StdDraw.draw();
    }

    public static void square(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new RuntimeException("square side length can't be negative");
        }
        double d4 = StdDraw.scaleX(d);
        double d5 = StdDraw.scaleY(d2);
        double d6 = StdDraw.factorX(2.0 * d3);
        double d7 = StdDraw.factorY(2.0 * d3);
        if (d6 <= 1.0 && d7 <= 1.0) {
            StdDraw.pixel(d, d2);
        } else {
            offscreen.draw(new Rectangle2D.Double(d4 - d6 / 2.0, d5 - d7 / 2.0, d6, d7));
        }
        StdDraw.draw();
    }

    public static void filledSquare(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new RuntimeException("square side length can't be negative");
        }
        double d4 = StdDraw.scaleX(d);
        double d5 = StdDraw.scaleY(d2);
        double d6 = StdDraw.factorX(2.0 * d3);
        double d7 = StdDraw.factorY(2.0 * d3);
        if (d6 <= 1.0 && d7 <= 1.0) {
            StdDraw.pixel(d, d2);
        } else {
            offscreen.fill(new Rectangle2D.Double(d4 - d6 / 2.0, d5 - d7 / 2.0, d6, d7));
        }
        StdDraw.draw();
    }

    public static void rectangle(double d, double d2, double d3, double d4) {
        if (d3 < 0.0) {
            throw new RuntimeException("half width can't be negative");
        }
        if (d4 < 0.0) {
            throw new RuntimeException("half height can't be negative");
        }
        double d5 = StdDraw.scaleX(d);
        double d6 = StdDraw.scaleY(d2);
        double d7 = StdDraw.factorX(2.0 * d3);
        double d8 = StdDraw.factorY(2.0 * d4);
        if (d7 <= 1.0 && d8 <= 1.0) {
            StdDraw.pixel(d, d2);
        } else {
            offscreen.draw(new Rectangle2D.Double(d5 - d7 / 2.0, d6 - d8 / 2.0, d7, d8));
        }
        StdDraw.draw();
    }

    public static void filledRectangle(double d, double d2, double d3, double d4) {
        if (d3 < 0.0) {
            throw new RuntimeException("half width can't be negative");
        }
        if (d4 < 0.0) {
            throw new RuntimeException("half height can't be negative");
        }
        double d5 = StdDraw.scaleX(d);
        double d6 = StdDraw.scaleY(d2);
        double d7 = StdDraw.factorX(2.0 * d3);
        double d8 = StdDraw.factorY(2.0 * d4);
        if (d7 <= 1.0 && d8 <= 1.0) {
            StdDraw.pixel(d, d2);
        } else {
            offscreen.fill(new Rectangle2D.Double(d5 - d7 / 2.0, d6 - d8 / 2.0, d7, d8));
        }
        StdDraw.draw();
    }

    public static void polygon(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)StdDraw.scaleX(dArray[0]), (float)StdDraw.scaleY(dArray2[0]));
        for (int i = 0; i < n; ++i) {
            generalPath.lineTo((float)StdDraw.scaleX(dArray[i]), (float)StdDraw.scaleY(dArray2[i]));
        }
        generalPath.closePath();
        offscreen.draw(generalPath);
        StdDraw.draw();
    }

    public static void filledPolygon(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)StdDraw.scaleX(dArray[0]), (float)StdDraw.scaleY(dArray2[0]));
        for (int i = 0; i < n; ++i) {
            generalPath.lineTo((float)StdDraw.scaleX(dArray[i]), (float)StdDraw.scaleY(dArray2[i]));
        }
        generalPath.closePath();
        offscreen.fill(generalPath);
        StdDraw.draw();
    }

    private static Image getImage(String string) {
        URL uRL;
        ImageIcon imageIcon = new ImageIcon(string);
        if (imageIcon == null || imageIcon.getImageLoadStatus() != 8) {
            try {
                uRL = new URL(string);
                imageIcon = new ImageIcon(uRL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (imageIcon == null || imageIcon.getImageLoadStatus() != 8) {
            uRL = StdDraw.class.getResource(string);
            if (uRL == null) {
                throw new RuntimeException("image " + string + " not found");
            }
            imageIcon = new ImageIcon(uRL);
        }
        return imageIcon.getImage();
    }

    public static void picture(double d, double d2, String string) {
        Image image = StdDraw.getImage(string);
        double d3 = StdDraw.scaleX(d);
        double d4 = StdDraw.scaleY(d2);
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n < 0 || n2 < 0) {
            throw new RuntimeException("image " + string + " is corrupt");
        }
        offscreen.drawImage(image, (int)Math.round(d3 - (double)n / 2.0), (int)Math.round(d4 - (double)n2 / 2.0), null);
        StdDraw.draw();
    }

    public static void picture(double d, double d2, String string, double d3) {
        Image image = StdDraw.getImage(string);
        double d4 = StdDraw.scaleX(d);
        double d5 = StdDraw.scaleY(d2);
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n < 0 || n2 < 0) {
            throw new RuntimeException("image " + string + " is corrupt");
        }
        offscreen.rotate(Math.toRadians(-d3), d4, d5);
        offscreen.drawImage(image, (int)Math.round(d4 - (double)n / 2.0), (int)Math.round(d5 - (double)n2 / 2.0), null);
        offscreen.rotate(Math.toRadians(d3), d4, d5);
        StdDraw.draw();
    }

    public static void picture(double d, double d2, String string, double d3, double d4) {
        Image image = StdDraw.getImage(string);
        double d5 = StdDraw.scaleX(d);
        double d6 = StdDraw.scaleY(d2);
        if (d3 < 0.0) {
            throw new RuntimeException("width is negative: " + d3);
        }
        if (d4 < 0.0) {
            throw new RuntimeException("height is negative: " + d4);
        }
        double d7 = StdDraw.factorX(d3);
        double d8 = StdDraw.factorY(d4);
        if (d7 < 0.0 || d8 < 0.0) {
            throw new RuntimeException("image " + string + " is corrupt");
        }
        if (d7 <= 1.0 && d8 <= 1.0) {
            StdDraw.pixel(d, d2);
        } else {
            offscreen.drawImage(image, (int)Math.round(d5 - d7 / 2.0), (int)Math.round(d6 - d8 / 2.0), (int)Math.round(d7), (int)Math.round(d8), null);
        }
        StdDraw.draw();
    }

    public static void picture(double d, double d2, String string, double d3, double d4, double d5) {
        Image image = StdDraw.getImage(string);
        double d6 = StdDraw.scaleX(d);
        double d7 = StdDraw.scaleY(d2);
        double d8 = StdDraw.factorX(d3);
        double d9 = StdDraw.factorY(d4);
        if (d8 < 0.0 || d9 < 0.0) {
            throw new RuntimeException("image " + string + " is corrupt");
        }
        if (d8 <= 1.0 && d9 <= 1.0) {
            StdDraw.pixel(d, d2);
        }
        offscreen.rotate(Math.toRadians(-d5), d6, d7);
        offscreen.drawImage(image, (int)Math.round(d6 - d8 / 2.0), (int)Math.round(d7 - d9 / 2.0), (int)Math.round(d8), (int)Math.round(d9), null);
        offscreen.rotate(Math.toRadians(d5), d6, d7);
        StdDraw.draw();
    }

    public static void text(double d, double d2, String string) {
        offscreen.setFont(font);
        FontMetrics fontMetrics = offscreen.getFontMetrics();
        double d3 = StdDraw.scaleX(d);
        double d4 = StdDraw.scaleY(d2);
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getDescent();
        offscreen.drawString(string, (float)(d3 - (double)n / 2.0), (float)(d4 + (double)n2));
        StdDraw.draw();
    }

    public static void text(double d, double d2, String string, double d3) {
        double d4 = StdDraw.scaleX(d);
        double d5 = StdDraw.scaleY(d2);
        offscreen.rotate(Math.toRadians(-d3), d4, d5);
        StdDraw.text(d, d2, string);
        offscreen.rotate(Math.toRadians(d3), d4, d5);
    }

    public static void textLeft(double d, double d2, String string) {
        offscreen.setFont(font);
        FontMetrics fontMetrics = offscreen.getFontMetrics();
        double d3 = StdDraw.scaleX(d);
        double d4 = StdDraw.scaleY(d2);
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getDescent();
        offscreen.drawString(string, (float)d3, (float)(d4 + (double)n2));
        StdDraw.show();
    }

    public static void textRight(double d, double d2, String string) {
        offscreen.setFont(font);
        FontMetrics fontMetrics = offscreen.getFontMetrics();
        double d3 = StdDraw.scaleX(d);
        double d4 = StdDraw.scaleY(d2);
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getDescent();
        offscreen.drawString(string, (float)(d3 - (double)n), (float)(d4 + (double)n2));
        StdDraw.show();
    }

    public static void show(int n) {
        defer = false;
        StdDraw.draw();
        try {
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Error sleeping");
        }
        defer = true;
    }

    public static void show() {
        defer = false;
        StdDraw.draw();
    }

    private static void draw() {
        if (defer) {
            return;
        }
        onscreen.drawImage((Image)offscreenImage, 0, 0, null);
        frame.repaint();
    }

    public static void save(String string) {
        File file = new File(string);
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        if (string2.toLowerCase().equals("png")) {
            try {
                ImageIO.write((RenderedImage)offscreenImage, string2, file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (string2.toLowerCase().equals("jpg")) {
            WritableRaster writableRaster = offscreenImage.getRaster();
            WritableRaster writableRaster2 = writableRaster.createWritableChild(0, 0, width, height, 0, 0, new int[]{0, 1, 2});
            DirectColorModel directColorModel = (DirectColorModel)offscreenImage.getColorModel();
            DirectColorModel directColorModel2 = new DirectColorModel(directColorModel.getPixelSize(), directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask());
            BufferedImage bufferedImage = new BufferedImage(directColorModel2, writableRaster2, false, null);
            try {
                ImageIO.write((RenderedImage)bufferedImage, string2, file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            System.out.println("Invalid image file type: " + string2);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        FileDialog fileDialog = new FileDialog((Frame)frame, "Use a .png or .jpg extension", 1);
        fileDialog.setVisible(true);
        String string = fileDialog.getFile();
        if (string != null) {
            StdDraw.save(fileDialog.getDirectory() + File.separator + fileDialog.getFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mousePressed() {
        Object object = mouseLock;
        synchronized (object) {
            return mousePressed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double mouseX() {
        Object object = mouseLock;
        synchronized (object) {
            return mouseX;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double mouseY() {
        Object object = mouseLock;
        synchronized (object) {
            return mouseY;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent mouseEvent) {
        Object object = mouseLock;
        synchronized (object) {
            mouseX = StdDraw.userX(mouseEvent.getX());
            mouseY = StdDraw.userY(mouseEvent.getY());
            mousePressed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        Object object = mouseLock;
        synchronized (object) {
            mousePressed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent mouseEvent) {
        Object object = mouseLock;
        synchronized (object) {
            mouseX = StdDraw.userX(mouseEvent.getX());
            mouseY = StdDraw.userY(mouseEvent.getY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseMoved(MouseEvent mouseEvent) {
        Object object = mouseLock;
        synchronized (object) {
            mouseX = StdDraw.userX(mouseEvent.getX());
            mouseY = StdDraw.userY(mouseEvent.getY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasNextKeyTyped() {
        Object object = keyLock;
        synchronized (object) {
            return !keysTyped.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char nextKeyTyped() {
        Object object = keyLock;
        synchronized (object) {
            return keysTyped.removeLast().charValue();
        }
    }

    public static boolean isKeyPressed(char c) {
        return keysDown.contains(Character.valueOf(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyTyped(KeyEvent keyEvent) {
        Object object = keyLock;
        synchronized (object) {
            keysTyped.addFirst(Character.valueOf(keyEvent.getKeyChar()));
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        keysDown.add(Character.valueOf(keyEvent.getKeyChar()));
    }

    public void keyReleased(KeyEvent keyEvent) {
        keysDown.remove(Character.valueOf(keyEvent.getKeyChar()));
    }

    public static void main(String[] stringArray) {
        StdDraw.square(0.2, 0.8, 0.1);
        StdDraw.filledSquare(0.8, 0.8, 0.2);
        StdDraw.circle(0.8, 0.2, 0.2);
        StdDraw.setPenColor(BOOK_RED);
        StdDraw.setPenRadius(0.02);
        StdDraw.arc(0.8, 0.2, 0.1, 200.0, 45.0);
        StdDraw.setPenRadius();
        StdDraw.setPenColor(BOOK_BLUE);
        double[] dArray = new double[]{0.1, 0.2, 0.3, 0.2};
        double[] dArray2 = new double[]{0.2, 0.3, 0.2, 0.1};
        StdDraw.filledPolygon(dArray, dArray2);
        StdDraw.setPenColor(BLACK);
        StdDraw.text(0.2, 0.5, "black text");
        StdDraw.setPenColor(WHITE);
        StdDraw.text(0.8, 0.8, "white text");
    }

    static {
        width = 512;
        height = 512;
        defer = false;
        mouseLock = new Object();
        keyLock = new Object();
        DEFAULT_FONT = new Font("SansSerif", 0, 16);
        std = new StdDraw();
        mousePressed = false;
        mouseX = 0.0;
        mouseY = 0.0;
        keysTyped = new LinkedList();
        keysDown = new TreeSet();
        StdDraw.init();
    }
}

