/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public final class StdAudio {
    public static final int SAMPLE_RATE = 44100;
    private static final int BYTES_PER_SAMPLE = 2;
    private static final int BITS_PER_SAMPLE = 16;
    private static final double MAX_16_BIT = 32767.0;
    private static final int SAMPLE_BUFFER_SIZE = 4096;
    private static SourceDataLine line;
    private static byte[] buffer;
    private static int bufferSize;

    private StdAudio() {
    }

    private static void init() {
        try {
            AudioFormat audioFormat = new AudioFormat(44100.0f, 16, 1, true, false);
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(audioFormat, 8192);
            buffer = new byte[2730];
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.exit(1);
        }
        line.start();
    }

    public static void close() {
        line.drain();
        line.stop();
    }

    public static void play(double d) {
        if (d < -1.0) {
            d = -1.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        short s = (short)(32767.0 * d);
        StdAudio.buffer[StdAudio.bufferSize++] = (byte)s;
        StdAudio.buffer[StdAudio.bufferSize++] = (byte)(s >> 8);
        if (bufferSize >= buffer.length) {
            line.write(buffer, 0, buffer.length);
            bufferSize = 0;
        }
    }

    public static void play(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            StdAudio.play(dArray[i]);
        }
    }

    public static double[] read(String string) {
        byte[] byArray = StdAudio.readByte(string);
        int n = byArray.length;
        double[] dArray = new double[n / 2];
        for (int i = 0; i < n / 2; ++i) {
            dArray[i] = (double)((short)(((byArray[2 * i + 1] & 0xFF) << 8) + (byArray[2 * i] & 0xFF))) / 32767.0;
        }
        return dArray;
    }

    public static void play(String string) {
        Object object;
        URL uRL = null;
        try {
            object = new File(string);
            if (((File)object).canRead()) {
                uRL = ((File)object).toURI().toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        if (uRL == null) {
            throw new RuntimeException("audio " + string + " not found");
        }
        object = Applet.newAudioClip(uRL);
        object.play();
    }

    public static void loop(String string) {
        Object object;
        URL uRL = null;
        try {
            object = new File(string);
            if (((File)object).canRead()) {
                uRL = ((File)object).toURI().toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        if (uRL == null) {
            throw new RuntimeException("audio " + string + " not found");
        }
        object = Applet.newAudioClip(uRL);
        object.loop();
    }

    private static byte[] readByte(String string) {
        byte[] byArray = null;
        AudioInputStream audioInputStream = null;
        try {
            URL uRL = StdAudio.class.getResource(string);
            audioInputStream = AudioSystem.getAudioInputStream(uRL);
            byArray = new byte[audioInputStream.available()];
            audioInputStream.read(byArray);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            throw new RuntimeException("Could not read " + string);
        }
        return byArray;
    }

    public static void save(String string, double[] dArray) {
        block5: {
            AudioFormat audioFormat = new AudioFormat(44100.0f, 16, 1, true, false);
            byte[] byArray = new byte[2 * dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                short s = (short)(dArray[i] * 32767.0);
                byArray[2 * i + 0] = (byte)s;
                byArray[2 * i + 1] = (byte)(s >> 8);
            }
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, audioFormat, dArray.length);
                if (string.endsWith(".wav") || string.endsWith(".WAV")) {
                    AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, new File(string));
                    break block5;
                }
                if (string.endsWith(".au") || string.endsWith(".AU")) {
                    AudioSystem.write(audioInputStream, AudioFileFormat.Type.AU, new File(string));
                    break block5;
                }
                throw new RuntimeException("File format not supported: " + string);
            }
            catch (Exception exception) {
                System.out.println(exception);
                System.exit(1);
            }
        }
    }

    private static double[] note(double d, double d2, double d3) {
        int n = (int)(44100.0 * d2);
        double[] dArray = new double[n + 1];
        for (int i = 0; i <= n; ++i) {
            dArray[i] = d3 * Math.sin(Math.PI * 2 * (double)i * d / 44100.0);
        }
        return dArray;
    }

    public static void main(String[] stringArray) {
        double d = 440.0;
        for (int i = 0; i <= 44100; ++i) {
            StdAudio.play(0.5 * Math.sin(Math.PI * 2 * d * (double)i / 44100.0));
        }
        int[] nArray = new int[]{0, 2, 4, 5, 7, 9, 11, 12};
        for (int i = 0; i < nArray.length; ++i) {
            double d2 = 440.0 * Math.pow(2.0, (double)nArray[i] / 12.0);
            StdAudio.play(StdAudio.note(d2, 1.0, 0.5));
        }
        StdAudio.close();
        System.exit(0);
    }

    static {
        bufferSize = 0;
        StdAudio.init();
    }
}

