/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.InputMismatchException;
import java.util.Locale;
import java.util.Scanner;

public final class In {
    private Scanner scanner;
    private String charsetName = "ISO-8859-1";
    private Locale usLocale = new Locale("en", "US");

    public In() {
        this.scanner = new Scanner((InputStream)new BufferedInputStream(System.in), this.charsetName);
        this.scanner.useLocale(this.usLocale);
    }

    public In(Socket socket) {
        try {
            InputStream inputStream = socket.getInputStream();
            this.scanner = new Scanner((InputStream)new BufferedInputStream(inputStream), this.charsetName);
            this.scanner.useLocale(this.usLocale);
        }
        catch (IOException iOException) {
            System.err.println("Could not open " + socket);
        }
    }

    public In(URL uRL) {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            this.scanner = new Scanner((InputStream)new BufferedInputStream(inputStream), this.charsetName);
            this.scanner.useLocale(this.usLocale);
        }
        catch (IOException iOException) {
            System.err.println("Could not open " + uRL);
        }
    }

    public In(File file) {
        try {
            this.scanner = new Scanner(file, this.charsetName);
            this.scanner.useLocale(this.usLocale);
        }
        catch (IOException iOException) {
            System.err.println("Could not open " + file);
        }
    }

    public In(String string) {
        try {
            File file = new File(string);
            if (file.exists()) {
                this.scanner = new Scanner(file, this.charsetName);
                this.scanner.useLocale(this.usLocale);
                return;
            }
            URL uRL = this.getClass().getResource(string);
            if (uRL == null) {
                uRL = new URL(string);
            }
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            this.scanner = new Scanner((InputStream)new BufferedInputStream(inputStream), this.charsetName);
            this.scanner.useLocale(this.usLocale);
        }
        catch (IOException iOException) {
            System.err.println("Could not open " + string);
        }
    }

    public boolean exists() {
        return this.scanner != null;
    }

    public boolean isEmpty() {
        return !this.scanner.hasNext();
    }

    public boolean hasNextLine() {
        return this.scanner.hasNextLine();
    }

    public String readLine() {
        String string = null;
        try {
            string = this.scanner.nextLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public char readChar() {
        String string = this.scanner.findWithinHorizon("(?s).", 1);
        return string.charAt(0);
    }

    public String readAll() {
        if (!this.scanner.hasNextLine()) {
            return null;
        }
        return this.scanner.useDelimiter("\\A").next();
    }

    public String readString() {
        return this.scanner.next();
    }

    public int readInt() {
        return this.scanner.nextInt();
    }

    public double readDouble() {
        return this.scanner.nextDouble();
    }

    public double readFloat() {
        return this.scanner.nextFloat();
    }

    public long readLong() {
        return this.scanner.nextLong();
    }

    public byte readByte() {
        return this.scanner.nextByte();
    }

    public boolean readBoolean() {
        String string = this.readString();
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        if (string.equals("1")) {
            return true;
        }
        if (string.equals("0")) {
            return false;
        }
        throw new InputMismatchException();
    }

    public static int[] readInts(String string) {
        In in = new In(string);
        String[] stringArray = in.readAll().trim().split("\\s+");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    public static double[] readDoubles(String string) {
        In in = new In(string);
        String[] stringArray = in.readAll().trim().split("\\s+");
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dArray[i] = Double.parseDouble(stringArray[i]);
        }
        return dArray;
    }

    public static String[] readStrings(String string) {
        In in = new In(string);
        String[] stringArray = in.readAll().trim().split("\\s+");
        return stringArray;
    }

    public static int[] readInts() {
        In in = new In();
        String[] stringArray = in.readAll().trim().split("\\s+");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    public static double[] readDoubles() {
        In in = new In();
        String[] stringArray = in.readAll().trim().split("\\s+");
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dArray[i] = Double.parseDouble(stringArray[i]);
        }
        return dArray;
    }

    public static String[] readStrings() {
        In in = new In();
        String[] stringArray = in.readAll().trim().split("\\s+");
        return stringArray;
    }

    public void close() {
        this.scanner.close();
    }

    public static void main(String[] stringArray) {
        String string;
        In in;
        String string2 = "http://introcs.cs.princeton.edu/stdlib/InTest.txt";
        System.out.println("readAll() from URL " + string2);
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In(string2);
            System.out.println(in.readAll());
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println();
        System.out.println("readLine() from URL " + string2);
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In(string2);
            while (!in.isEmpty()) {
                string = in.readLine();
                System.out.println(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println();
        System.out.println("readString() from URL " + string2);
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In(string2);
            while (!in.isEmpty()) {
                string = in.readString();
                System.out.println(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println();
        System.out.println("readLine() from current directory");
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In("./InTest.txt");
            while (!in.isEmpty()) {
                string = in.readLine();
                System.out.println(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println();
        System.out.println("readLine() from relative path");
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In("../stdlib/InTest.txt");
            while (!in.isEmpty()) {
                string = in.readLine();
                System.out.println(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println();
        System.out.println("readChar() from file");
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In("InTest.txt");
            while (!in.isEmpty()) {
                char c = in.readChar();
                System.out.print(c);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println();
        System.out.println();
        System.out.println("readLine() from absolute OS X / Linux path");
        System.out.println("---------------------------------------------------------------------------");
        in = new In("/n/fs/csweb/introcs/stdlib/InTest.txt");
        try {
            while (!in.isEmpty()) {
                String string3 = in.readLine();
                System.out.println(string3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println();
        System.out.println("readLine() from absolute Windows path");
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In("G:\\www\\introcs\\stdlib\\InTest.txt");
            while (!in.isEmpty()) {
                String string4 = in.readLine();
                System.out.println(string4);
            }
            System.out.println();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println();
    }
}

