/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;

public class DrawRoute {
    public static int find(City[] cityArray, String string) {
        int n = 0;
        int n2 = cityArray.length - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            if (cityArray[n3].name.equals(string)) {
                return n3;
            }
            if (cityArray[n3].name.compareTo(string) < 0) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
        return -1;
    }

    public static double distFrom(double d, double d2, double d3, double d4) {
        double d5 = 3959.0;
        double d6 = Math.toRadians(d3 - d);
        double d7 = Math.toRadians(d4 - d2);
        double d8 = Math.sin(d6 / 2.0) * Math.sin(d6 / 2.0) + Math.cos(Math.toRadians(d)) * Math.cos(Math.toRadians(d3)) * Math.sin(d7 / 2.0) * Math.sin(d7 / 2.0);
        double d9 = 2.0 * Math.atan2(Math.sqrt(d8), Math.sqrt(1.0 - d8));
        double d10 = d5 * d9;
        return d10;
    }

    public static double bearing(double d, double d2, double d3, double d4) {
        double d5 = Math.toRadians(d4 - d2);
        d = Math.toRadians(d);
        d3 = Math.toRadians(d3);
        double d6 = Math.sin(d5) * Math.cos(d3);
        double d7 = Math.cos(d) * Math.sin(d3) - Math.sin(d) * Math.cos(d3) * Math.cos(d5);
        double d8 = Math.atan2(d6, d7);
        return d8;
    }

    public static double destLat(double d, double d2, double d3, double d4) {
        double d5 = 3959.0;
        d = Math.toRadians(d);
        d2 = Math.toRadians(d2);
        return Math.asin(Math.sin(d) * Math.cos(d4 / d5) + Math.cos(d) * Math.sin(d4 / d5) * Math.cos(d3));
    }

    public static double destLng(double d, double d2, double d3, double d4, double d5) {
        double d6 = 3959.0;
        d = Math.toRadians(d);
        d2 = Math.toRadians(d2);
        return d2 + Math.atan2(Math.sin(d3) * Math.sin(d4 / d6) * Math.cos(d), Math.cos(d4 / d6) - Math.sin(d) * Math.sin(d5));
    }

    private static double[] pointRadialDistance(double d, double d2, double d3, double d4) {
        double d5 = Math.toRadians(d);
        double d6 = Math.toRadians(d2);
        double d7 = Math.toRadians(d3);
        double d8 = d4 / 3968.0;
        double d9 = Math.asin(Math.sin(d5) * Math.cos(d8) + Math.cos(d5) * Math.sin(d8) * Math.cos(d7));
        double d10 = Math.cos(d9) == 0.0 || Math.abs(Math.cos(d9)) < 1.0E-5 ? Math.toDegrees(d6) : Math.toDegrees((d6 - Math.asin(Math.sin(d7) * Math.sin(d8) / Math.cos(d5)) + Math.PI) % (Math.PI * 2) - Math.PI);
        return new double[]{Math.toDegrees(d9), d10};
    }

    public static void main(String[] stringArray) {
        int n;
        Line line;
        String string;
        int n2;
        Mercator mercator = new Mercator();
        double d = 1609.344;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        Draw draw = new Draw();
        draw.setCanvasSize(1024, 768);
        draw.setXscale(0.0, 4300.0);
        draw.setYscale(0.0, 2000.0);
        if (stringArray.length > 0) {
            if (stringArray[0].equals("-h")) {
                System.out.println("Usage: java -jar DrawNetwork [-b <file.jpg>] < <inputRoute>");
                System.out.println("\t-b use background jpg image <file.jpg>");
                System.exit(0);
            } else if (stringArray[0].equals("-b")) {
                if (stringArray.length > 1) {
                    draw.picture(2100.0, 1000.0, stringArray[1]);
                    draw.show();
                } else {
                    System.out.println("Please specify background file.");
                    System.exit(0);
                }
            }
        }
        int n3 = StdIn.readInt();
        City[] cityArray = new City[n3];
        boolean[] blArray = new boolean[n3];
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            String string2 = StdIn.readString();
            double d2 = StdIn.readDouble();
            double d3 = StdIn.readDouble();
            if (bl) {
                System.out.println(string2 + " " + d2 + " " + d3);
            }
            cityArray[n2] = new City(string2, d2, d3);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            Object object;
            double d4;
            Object object2;
            if (bl3) {
                object2 = mercator.merc(cityArray[n2].lng, cityArray[n2].lat);
                double d5 = cityArray[n2].lat;
                double d6 = cityArray[n2].lng;
                d4 = d5 > 45.0 ? 8990.0 - object2[0] / d * 1.03 : (d5 > 44.0 ? 9650.0 - object2[0] / d * 1.13 : (d5 > 42.0 ? 9590.0 - object2[0] / d * 1.124 : (d5 > 40.0 ? 9630.0 - object2[0] / d * 1.124 : (d5 > 35.0 ? 10110.0 - object2[0] / d * 1.198 : (d5 > 30.0 ? 10490.0 - object2[0] / d * 1.253 : (d5 > 27.0 ? 10940.0 - object2[0] / d * 1.32 : 11040.0 - object2[0] / d * 1.32))))));
                object = d6 > 120.0 ? object2[1] / d * 0.7 - 875.0 : (d6 > 115.0 ? object2[1] / d * 0.76 - 1100.0 : (d6 > 110.0 ? object2[1] / d * 0.76 - 1190.0 : (d6 > 100.0 ? object2[1] / d * 0.855 - 1485.0 : (d6 > 90.0 ? object2[1] / d * 0.82 - 1385.0 : (d6 > 86.0 ? (Object)(object2[1] / d * 0.825 - 1400.0) : (d6 > 85.0 ? (Object)(object2[1] / d * 0.825 - 1370.0) : (d6 > 82.0 ? (Object)(object2[1] / d * 0.795 - 1290.0) : (d6 > 80.0 ? (Object)(object2[1] / d * 0.79 - 1250.0) : (d6 > 75.0 ? (Object)(object2[1] / d * 0.805 - 1270.0) : (d6 > 70.0 ? (Object)(object2[1] / d * 0.795 - 1190.0) : (Object)(object2[1] / d * 0.795 - 1180.0)))))))))));
                if (bl) {
                    System.out.println("City " + cityArray[n2].name + " x/y " + d4 + "," + object);
                }
            } else {
                double d7;
                double d8;
                double d9;
                double d10;
                double d11 = 87.65;
                double d12 = 39.75;
                double d13 = DrawRoute.distFrom(cityArray[n2].lat, cityArray[n2].lng, d12, d11);
                double d14 = DrawRoute.bearing(d12, d11, cityArray[n2].lat, cityArray[n2].lng);
                if (cityArray[n2].lng < d11 && cityArray[n2].lat < d12) {
                    d10 = 1.6;
                    d9 = 1750.0;
                    d14 *= 0.95;
                    d8 = cityArray[n2].lng / d11;
                    d7 = cityArray[n2].lat / d12;
                } else if (cityArray[n2].lng < d11 && cityArray[n2].lat > d12) {
                    d10 = 1.6;
                    d9 = 1700.0;
                    d14 *= 0.98;
                    d8 = cityArray[n2].lng / d11;
                    d7 = d12 * 0.95 / cityArray[n2].lat;
                } else if (cityArray[n2].lng > d11 && cityArray[n2].lat < d12) {
                    d10 = 1.45;
                    d9 = 1850.0;
                    d14 *= 1.05;
                    d8 = d11 * 0.9 / cityArray[n2].lng;
                    d7 = cityArray[n2].lat / (d12 * 0.9);
                } else {
                    d10 = 1.6;
                    d9 = 1800.0;
                    d14 *= 1.01;
                    d8 = d11 / cityArray[n2].lng;
                    d7 = d12 * 0.85 / cityArray[n2].lat;
                }
                d4 = (-Math.sin(d14) * d13 + d9) * d10;
                object = (Math.cos(d14) * d13 * d8 * d7 + 650.0) * 1.6;
            }
            object2 = new Circle(draw);
            ((Circle)object2).setRadius(3.0);
            ((Figure)object2).setLocation(d4, (double)object);
            ((Circle)object2).draw();
            if (cityArray[n2].name.equals("Atlanta") || cityArray[n2].name.equals("Albuquerque") || cityArray[n2].name.equals("Boston") || cityArray[n2].name.equals("Salt-Lake-City") || cityArray[n2].name.equals("Chicago") || cityArray[n2].name.equals("Denver") || cityArray[n2].name.equals("Miami") || cityArray[n2].name.equals("Minneapolis") || cityArray[n2].name.equals("Dallas") || cityArray[n2].name.equals("Houston") || cityArray[n2].name.equals("Tampa") || cityArray[n2].name.equals("Los-Angeles") || cityArray[n2].name.equals("Seattle") || cityArray[n2].name.equals("Philadelphia") || cityArray[n2].name.equals("Phoenix") || cityArray[n2].name.equals("Portland") || cityArray[n2].name.equals("San-Francisco") || cityArray[n2].name.equals("Washington-DC") || cityArray[n2].name.equals("New-York")) {
                Text text = new Text(draw);
                text.setText(cityArray[n2].name);
                text.setFont(new Font("SansSerif", 0, 9));
                text.setLocation(d4, (double)object);
                text.draw();
            }
            cityArray[n2].x = d4;
            cityArray[n2].y = object;
            if (!bl) continue;
            System.out.println(cityArray[n2].name + ":" + d4 + "," + object);
        }
        Connection[][] connectionArrayArray = new Connection[n3][];
        boolean bl4 = false;
        while (!StdIn.isEmpty() && !(string = StdIn.readString()).equals("Route:")) {
            int n4 = StdIn.readInt();
            int n5 = DrawRoute.find(cityArray, string);
            nArray[n5] = n4;
            blArray[n5] = true;
            if (bl2) {
                System.out.println("Setting up connection for " + string + "/cities " + n5);
            }
            connectionArrayArray[n5] = new Connection[n4];
            for (int i = 0; i < n4; ++i) {
                String string3 = StdIn.readString();
                if (bl2) {
                    System.out.println("found " + string3);
                }
                int n6 = StdIn.readInt();
                String string4 = StdIn.readString();
                int n7 = DrawRoute.find(cityArray, string3);
                if (n7 == -1) {
                    System.out.println("Can't find " + string3);
                    continue;
                }
                int n8 = n7;
                nArray2[n8] = nArray2[n8] + 1;
                if (bl2) {
                    System.out.println(string3 + " " + string4 + " " + n6);
                }
                connectionArrayArray[n5][i] = new Connection(string3, string4, n6);
                line = new Line(draw);
                line.setColor(Color.LIGHT_GRAY);
                line.setLocation(cityArray[n5].x, cityArray[n5].y);
                line.setLocation2(cityArray[n7].x, cityArray[n7].y);
                line.draw();
            }
        }
        for (n = 0; n < n3; ++n) {
            if (!blArray[n]) {
                System.out.println("Missing connections for " + cityArray[n].name);
            }
            if (nArray2[n] == nArray[n]) continue;
            System.out.println("Wrong connection count for " + cityArray[n].name);
        }
        if (!StdIn.isEmpty()) {
            n = StdIn.readInt();
            boolean bl5 = true;
            Text text = new Text(draw);
            text.setLocation(3000.0, 1800.0);
            text.setFont(new Font("SansSerif", 0, 16));
            text.setText("Total Distance: " + n);
            text.draw();
            text.setFont(new Font("SansSerif", 0, 9));
            while (!StdIn.isEmpty()) {
                String string5 = StdIn.readString();
                String string6 = StdIn.readString();
                String string7 = StdIn.readString();
                int n9 = DrawRoute.find(cityArray, string5);
                int n10 = DrawRoute.find(cityArray, string6);
                if (n9 == -1) {
                    System.out.println("Can't find " + string5);
                    System.exit(0);
                }
                if (n10 == -1) {
                    System.out.println("Can't find " + string6);
                    System.exit(0);
                }
                text.setColor(Color.BLACK);
                if (bl5) {
                    text.setText(string5);
                    text.setLocation(cityArray[n9].x, cityArray[n9].y);
                    text.draw();
                }
                text.setFont(new Font("SansSerif", 0, 7));
                text.setText(string7);
                text.setLocation((cityArray[n10].x + cityArray[n9].x) / 2.0, (cityArray[n10].y + cityArray[n9].y) / 2.0);
                text.draw();
                text.setFont(new Font("SansSerif", 0, 9));
                text.setText(string6);
                text.setLocation(cityArray[n10].x, cityArray[n10].y);
                text.draw();
                line = new Line(draw);
                line.setColor(Color.RED);
                line.setLocation(cityArray[n9].x, cityArray[n9].y);
                line.setLocation2(cityArray[n10].x, cityArray[n10].y);
                line.draw();
            }
        }
    }
}

