/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public final class Draw
implements ActionListener,
MouseListener,
MouseMotionListener,
KeyListener {
    public static final Color BLACK = Color.BLACK;
    public static final Color BLUE = Color.BLUE;
    public static final Color CYAN = Color.CYAN;
    public static final Color DARK_GRAY = Color.DARK_GRAY;
    public static final Color GRAY = Color.GRAY;
    public static final Color GREEN = Color.GREEN;
    public static final Color LIGHT_GRAY = Color.LIGHT_GRAY;
    public static final Color MAGENTA = Color.MAGENTA;
    public static final Color ORANGE = Color.ORANGE;
    public static final Color PINK = Color.PINK;
    public static final Color RED = Color.RED;
    public static final Color WHITE = Color.WHITE;
    public static final Color YELLOW = Color.YELLOW;
    public static final Color BOOK_BLUE = new Color(9, 90, 166);
    public static final Color BOOK_RED = new Color(173, 32, 24);
    private static final Color DEFAULT_PEN_COLOR = BLACK;
    private static final Color DEFAULT_CLEAR_COLOR = WHITE;
    private Color penColor;
    private static final int DEFAULT_SIZE = 512;
    private int width = 512;
    private int height = 512;
    private static final double DEFAULT_PEN_RADIUS = 0.002;
    private double penRadius;
    private boolean defer = false;
    private static final double BORDER = 0.05;
    private static final double DEFAULT_XMIN = 0.0;
    private static final double DEFAULT_XMAX = 1.0;
    private static final double DEFAULT_YMIN = 0.0;
    private static final double DEFAULT_YMAX = 1.0;
    private double xmin;
    private double ymin;
    private double xmax;
    private double ymax;
    private String name = "Draw";
    private Object mouseLock = new Object();
    private Object keyLock = new Object();
    private static final Font DEFAULT_FONT = new Font("SansSerif", 0, 16);
    private Font font;
    private BufferedImage offscreenImage;
    private BufferedImage onscreenImage;
    private Graphics2D offscreen;
    private Graphics2D onscreen;
    private JFrame frame = new JFrame();
    private boolean mousePressed = false;
    private double mouseX = 0.0;
    private double mouseY = 0.0;
    private LinkedList<Character> keysTyped = new LinkedList();

    public Draw(String string) {
        this.name = string;
        this.init();
    }

    public Draw() {
        this.init();
    }

    private void init() {
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
        this.frame = new JFrame();
        this.offscreenImage = new BufferedImage(this.width, this.height, 2);
        this.onscreenImage = new BufferedImage(this.width, this.height, 2);
        this.offscreen = this.offscreenImage.createGraphics();
        this.onscreen = this.onscreenImage.createGraphics();
        this.setXscale();
        this.setYscale();
        this.offscreen.setColor(DEFAULT_CLEAR_COLOR);
        this.offscreen.fillRect(0, 0, this.width, this.height);
        this.setPenColor();
        this.setPenRadius();
        this.setFont();
        this.clear();
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.offscreen.addRenderingHints(renderingHints);
        ImageIcon imageIcon = new ImageIcon(this.onscreenImage);
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.addMouseListener(this);
        jLabel.addMouseMotionListener(this);
        this.frame.setContentPane(jLabel);
        this.frame.addKeyListener(this);
        this.frame.setResizable(false);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setTitle(this.name);
        this.frame.setJMenuBar(this.createMenuBar());
        this.frame.pack();
        this.frame.requestFocusInWindow();
        this.frame.setVisible(true);
    }

    public void setLocationOnScreen(int n, int n2) {
        this.frame.setLocation(n, n2);
    }

    public void setCanvasSize(int n, int n2) {
        if (n < 1 || n2 < 1) {
            throw new RuntimeException("width and height must be positive");
        }
        this.width = n;
        this.height = n2;
        this.init();
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(" Save...   ");
        jMenuItem.addActionListener(this);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.add(jMenuItem);
        return jMenuBar;
    }

    public void setXscale() {
        this.setXscale(0.0, 1.0);
    }

    public void setYscale() {
        this.setYscale(0.0, 1.0);
    }

    public void setXscale(double d, double d2) {
        double d3 = d2 - d;
        this.xmin = d - 0.05 * d3;
        this.xmax = d2 + 0.05 * d3;
    }

    public void setYscale(double d, double d2) {
        double d3 = d2 - d;
        this.ymin = d - 0.05 * d3;
        this.ymax = d2 + 0.05 * d3;
    }

    private double scaleX(double d) {
        return (double)this.width * (d - this.xmin) / (this.xmax - this.xmin);
    }

    private double scaleY(double d) {
        return (double)this.height * (this.ymax - d) / (this.ymax - this.ymin);
    }

    private double factorX(double d) {
        return d * (double)this.width / Math.abs(this.xmax - this.xmin);
    }

    private double factorY(double d) {
        return d * (double)this.height / Math.abs(this.ymax - this.ymin);
    }

    private double userX(double d) {
        return this.xmin + d * (this.xmax - this.xmin) / (double)this.width;
    }

    private double userY(double d) {
        return this.ymax - d * (this.ymax - this.ymin) / (double)this.height;
    }

    public void clear() {
        this.clear(DEFAULT_CLEAR_COLOR);
    }

    public void clear(Color color) {
        this.offscreen.setColor(color);
        this.offscreen.fillRect(0, 0, this.width, this.height);
        this.offscreen.setColor(this.penColor);
        this.draw();
    }

    public double getPenRadius() {
        return this.penRadius;
    }

    public void setPenRadius() {
        this.setPenRadius(0.002);
    }

    public void setPenRadius(double d) {
        if (d < 0.0) {
            throw new RuntimeException("pen radius must be positive");
        }
        this.penRadius = d * 512.0;
        BasicStroke basicStroke = new BasicStroke((float)this.penRadius, 1, 1);
        this.offscreen.setStroke(basicStroke);
    }

    public Color getPenColor() {
        return this.penColor;
    }

    public void setPenColor() {
        this.setPenColor(DEFAULT_PEN_COLOR);
    }

    public void setPenColor(Color color) {
        this.penColor = color;
        this.offscreen.setColor(this.penColor);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont() {
        this.setFont(DEFAULT_FONT);
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void line(double d, double d2, double d3, double d4) {
        this.offscreen.draw(new Line2D.Double(this.scaleX(d), this.scaleY(d2), this.scaleX(d3), this.scaleY(d4)));
        this.draw();
    }

    private void pixel(double d, double d2) {
        this.offscreen.fillRect((int)Math.round(this.scaleX(d)), (int)Math.round(this.scaleY(d2)), 1, 1);
    }

    public void point(double d, double d2) {
        double d3 = this.scaleX(d);
        double d4 = this.scaleY(d2);
        double d5 = this.penRadius;
        if (d5 <= 1.0) {
            this.pixel(d, d2);
        } else {
            this.offscreen.fill(new Ellipse2D.Double(d3 - d5 / 2.0, d4 - d5 / 2.0, d5, d5));
        }
        this.draw();
    }

    public void circle(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new RuntimeException("circle radius can't be negative");
        }
        double d4 = this.scaleX(d);
        double d5 = this.scaleY(d2);
        double d6 = this.factorX(2.0 * d3);
        double d7 = this.factorY(2.0 * d3);
        if (d6 <= 1.0 && d7 <= 1.0) {
            this.pixel(d, d2);
        } else {
            this.offscreen.draw(new Ellipse2D.Double(d4 - d6 / 2.0, d5 - d7 / 2.0, d6, d7));
        }
        this.draw();
    }

    public void filledCircle(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new RuntimeException("circle radius can't be negative");
        }
        double d4 = this.scaleX(d);
        double d5 = this.scaleY(d2);
        double d6 = this.factorX(2.0 * d3);
        double d7 = this.factorY(2.0 * d3);
        if (d6 <= 1.0 && d7 <= 1.0) {
            this.pixel(d, d2);
        } else {
            this.offscreen.fill(new Ellipse2D.Double(d4 - d6 / 2.0, d5 - d7 / 2.0, d6, d7));
        }
        this.draw();
    }

    public void ellipse(double d, double d2, double d3, double d4) {
        if (d3 < 0.0) {
            throw new RuntimeException("ellipse semimajor axis can't be negative");
        }
        if (d4 < 0.0) {
            throw new RuntimeException("ellipse semiminor axis can't be negative");
        }
        double d5 = this.scaleX(d);
        double d6 = this.scaleY(d2);
        double d7 = this.factorX(2.0 * d3);
        double d8 = this.factorY(2.0 * d4);
        if (d7 <= 1.0 && d8 <= 1.0) {
            this.pixel(d, d2);
        } else {
            this.offscreen.draw(new Ellipse2D.Double(d5 - d7 / 2.0, d6 - d8 / 2.0, d7, d8));
        }
        this.draw();
    }

    public void filledEllipse(double d, double d2, double d3, double d4) {
        if (d3 < 0.0) {
            throw new RuntimeException("ellipse semimajor axis can't be negative");
        }
        if (d4 < 0.0) {
            throw new RuntimeException("ellipse semiminor axis can't be negative");
        }
        double d5 = this.scaleX(d);
        double d6 = this.scaleY(d2);
        double d7 = this.factorX(2.0 * d3);
        double d8 = this.factorY(2.0 * d4);
        if (d7 <= 1.0 && d8 <= 1.0) {
            this.pixel(d, d2);
        } else {
            this.offscreen.fill(new Ellipse2D.Double(d5 - d7 / 2.0, d6 - d8 / 2.0, d7, d8));
        }
        this.draw();
    }

    public void arc(double d, double d2, double d3, double d4, double d5) {
        if (d3 < 0.0) {
            throw new RuntimeException("arc radius can't be negative");
        }
        while (d5 < d4) {
            d5 += 360.0;
        }
        double d6 = this.scaleX(d);
        double d7 = this.scaleY(d2);
        double d8 = this.factorX(2.0 * d3);
        double d9 = this.factorY(2.0 * d3);
        if (d8 <= 1.0 && d9 <= 1.0) {
            this.pixel(d, d2);
        } else {
            this.offscreen.draw(new Arc2D.Double(d6 - d8 / 2.0, d7 - d9 / 2.0, d8, d9, d4, d5 - d4, 0));
        }
        this.draw();
    }

    public void square(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new RuntimeException("square side length can't be negative");
        }
        double d4 = this.scaleX(d);
        double d5 = this.scaleY(d2);
        double d6 = this.factorX(2.0 * d3);
        double d7 = this.factorY(2.0 * d3);
        if (d6 <= 1.0 && d7 <= 1.0) {
            this.pixel(d, d2);
        } else {
            this.offscreen.draw(new Rectangle2D.Double(d4 - d6 / 2.0, d5 - d7 / 2.0, d6, d7));
        }
        this.draw();
    }

    public void filledSquare(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new RuntimeException("square side length can't be negative");
        }
        double d4 = this.scaleX(d);
        double d5 = this.scaleY(d2);
        double d6 = this.factorX(2.0 * d3);
        double d7 = this.factorY(2.0 * d3);
        if (d6 <= 1.0 && d7 <= 1.0) {
            this.pixel(d, d2);
        } else {
            this.offscreen.fill(new Rectangle2D.Double(d4 - d6 / 2.0, d5 - d7 / 2.0, d6, d7));
        }
        this.draw();
    }

    public void rectangle(double d, double d2, double d3, double d4) {
        if (d3 < 0.0) {
            throw new RuntimeException("half width can't be negative");
        }
        if (d4 < 0.0) {
            throw new RuntimeException("half height can't be negative");
        }
        double d5 = this.scaleX(d);
        double d6 = this.scaleY(d2);
        double d7 = this.factorX(2.0 * d3);
        double d8 = this.factorY(2.0 * d4);
        if (d7 <= 1.0 && d8 <= 1.0) {
            this.pixel(d, d2);
        } else {
            this.offscreen.draw(new Rectangle2D.Double(d5 - d7 / 2.0, d6 - d8 / 2.0, d7, d8));
        }
        this.draw();
    }

    public void filledRectangle(double d, double d2, double d3, double d4) {
        if (d3 < 0.0) {
            throw new RuntimeException("half width can't be negative");
        }
        if (d4 < 0.0) {
            throw new RuntimeException("half height can't be negative");
        }
        double d5 = this.scaleX(d);
        double d6 = this.scaleY(d2);
        double d7 = this.factorX(2.0 * d3);
        double d8 = this.factorY(2.0 * d4);
        if (d7 <= 1.0 && d8 <= 1.0) {
            this.pixel(d, d2);
        } else {
            this.offscreen.fill(new Rectangle2D.Double(d5 - d7 / 2.0, d6 - d8 / 2.0, d7, d8));
        }
        this.draw();
    }

    public void polygon(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.scaleX(dArray[0]), (float)this.scaleY(dArray2[0]));
        for (int i = 0; i < n; ++i) {
            generalPath.lineTo((float)this.scaleX(dArray[i]), (float)this.scaleY(dArray2[i]));
        }
        generalPath.closePath();
        this.offscreen.draw(generalPath);
        this.draw();
    }

    public void filledPolygon(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.scaleX(dArray[0]), (float)this.scaleY(dArray2[0]));
        for (int i = 0; i < n; ++i) {
            generalPath.lineTo((float)this.scaleX(dArray[i]), (float)this.scaleY(dArray2[i]));
        }
        generalPath.closePath();
        this.offscreen.fill(generalPath);
        this.draw();
    }

    private Image getImage(String string) {
        URL uRL;
        ImageIcon imageIcon = new ImageIcon(string);
        if (imageIcon == null || imageIcon.getImageLoadStatus() != 8) {
            try {
                uRL = new URL(string);
                imageIcon = new ImageIcon(uRL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (imageIcon == null || imageIcon.getImageLoadStatus() != 8) {
            uRL = Draw.class.getResource(string);
            if (uRL == null) {
                throw new RuntimeException("image " + string + " not found");
            }
            imageIcon = new ImageIcon(uRL);
        }
        return imageIcon.getImage();
    }

    public void picture(double d, double d2, String string) {
        Image image = this.getImage(string);
        double d3 = this.scaleX(d);
        double d4 = this.scaleY(d2);
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n < 0 || n2 < 0) {
            throw new RuntimeException("image " + string + " is corrupt");
        }
        this.offscreen.drawImage(image, (int)Math.round(d3 - (double)n / 2.0), (int)Math.round(d4 - (double)n2 / 2.0), null);
        this.draw();
    }

    public void picture(double d, double d2, String string, double d3) {
        Image image = this.getImage(string);
        double d4 = this.scaleX(d);
        double d5 = this.scaleY(d2);
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n < 0 || n2 < 0) {
            throw new RuntimeException("image " + string + " is corrupt");
        }
        this.offscreen.rotate(Math.toRadians(-d3), d4, d5);
        this.offscreen.drawImage(image, (int)Math.round(d4 - (double)n / 2.0), (int)Math.round(d5 - (double)n2 / 2.0), null);
        this.offscreen.rotate(Math.toRadians(d3), d4, d5);
        this.draw();
    }

    public void picture(double d, double d2, String string, double d3, double d4) {
        Image image = this.getImage(string);
        double d5 = this.scaleX(d);
        double d6 = this.scaleY(d2);
        double d7 = this.factorX(d3);
        double d8 = this.factorY(d4);
        if (d7 < 0.0 || d8 < 0.0) {
            throw new RuntimeException("image " + string + " is corrupt");
        }
        if (d7 <= 1.0 && d8 <= 1.0) {
            this.pixel(d, d2);
        } else {
            this.offscreen.drawImage(image, (int)Math.round(d5 - d7 / 2.0), (int)Math.round(d6 - d8 / 2.0), (int)Math.round(d7), (int)Math.round(d8), null);
        }
        this.draw();
    }

    public void picture(double d, double d2, String string, double d3, double d4, double d5) {
        Image image = this.getImage(string);
        double d6 = this.scaleX(d);
        double d7 = this.scaleY(d2);
        double d8 = this.factorX(d3);
        double d9 = this.factorY(d4);
        if (d8 < 0.0 || d9 < 0.0) {
            throw new RuntimeException("image " + string + " is corrupt");
        }
        if (d8 <= 1.0 && d9 <= 1.0) {
            this.pixel(d, d2);
        }
        this.offscreen.rotate(Math.toRadians(-d5), d6, d7);
        this.offscreen.drawImage(image, (int)Math.round(d6 - d8 / 2.0), (int)Math.round(d7 - d9 / 2.0), (int)Math.round(d8), (int)Math.round(d9), null);
        this.offscreen.rotate(Math.toRadians(d5), d6, d7);
        this.draw();
    }

    public void text(double d, double d2, String string) {
        this.offscreen.setFont(this.font);
        FontMetrics fontMetrics = this.offscreen.getFontMetrics();
        double d3 = this.scaleX(d);
        double d4 = this.scaleY(d2);
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getDescent();
        this.offscreen.drawString(string, (float)(d3 - (double)n / 2.0), (float)(d4 + (double)n2));
        this.draw();
    }

    public void text(double d, double d2, String string, double d3) {
        double d4 = this.scaleX(d);
        double d5 = this.scaleY(d2);
        this.offscreen.rotate(Math.toRadians(-d3), d4, d5);
        this.text(d, d2, string);
        this.offscreen.rotate(Math.toRadians(d3), d4, d5);
    }

    public void textLeft(double d, double d2, String string) {
        this.offscreen.setFont(this.font);
        FontMetrics fontMetrics = this.offscreen.getFontMetrics();
        double d3 = this.scaleX(d);
        double d4 = this.scaleY(d2);
        int n = fontMetrics.getDescent();
        this.offscreen.drawString(string, (float)d3, (float)(d4 + (double)n));
        this.show();
    }

    public void show(int n) {
        this.defer = false;
        this.draw();
        try {
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Error sleeping");
        }
        this.defer = true;
    }

    public void show() {
        this.defer = false;
        this.draw();
    }

    private void draw() {
        if (this.defer) {
            return;
        }
        this.onscreen.drawImage((Image)this.offscreenImage, 0, 0, null);
        this.frame.repaint();
    }

    public void save(String string) {
        File file = new File(string);
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        if (string2.toLowerCase().equals("png")) {
            try {
                ImageIO.write((RenderedImage)this.offscreenImage, string2, file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (string2.toLowerCase().equals("jpg")) {
            WritableRaster writableRaster = this.offscreenImage.getRaster();
            WritableRaster writableRaster2 = writableRaster.createWritableChild(0, 0, this.width, this.height, 0, 0, new int[]{0, 1, 2});
            DirectColorModel directColorModel = (DirectColorModel)this.offscreenImage.getColorModel();
            DirectColorModel directColorModel2 = new DirectColorModel(directColorModel.getPixelSize(), directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask());
            BufferedImage bufferedImage = new BufferedImage(directColorModel2, writableRaster2, false, null);
            try {
                ImageIO.write((RenderedImage)bufferedImage, string2, file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            System.out.println("Invalid image file type: " + string2);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        FileDialog fileDialog = new FileDialog((Frame)this.frame, "Use a .png or .jpg extension", 1);
        fileDialog.setVisible(true);
        String string = fileDialog.getFile();
        if (string != null) {
            this.save(fileDialog.getDirectory() + File.separator + fileDialog.getFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mousePressed() {
        Object object = this.mouseLock;
        synchronized (object) {
            return this.mousePressed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double mouseX() {
        Object object = this.mouseLock;
        synchronized (object) {
            return this.mouseX;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double mouseY() {
        Object object = this.mouseLock;
        synchronized (object) {
            return this.mouseY;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent mouseEvent) {
        Object object = this.mouseLock;
        synchronized (object) {
            this.mouseX = this.userX(mouseEvent.getX());
            this.mouseY = this.userY(mouseEvent.getY());
            this.mousePressed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        Object object = this.mouseLock;
        synchronized (object) {
            this.mousePressed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent mouseEvent) {
        Object object = this.mouseLock;
        synchronized (object) {
            this.mouseX = this.userX(mouseEvent.getX());
            this.mouseY = this.userY(mouseEvent.getY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseMoved(MouseEvent mouseEvent) {
        Object object = this.mouseLock;
        synchronized (object) {
            this.mouseX = this.userX(mouseEvent.getX());
            this.mouseY = this.userY(mouseEvent.getY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNextKeyTyped() {
        Object object = this.keyLock;
        synchronized (object) {
            return !this.keysTyped.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char nextKeyTyped() {
        Object object = this.keyLock;
        synchronized (object) {
            return this.keysTyped.removeLast().charValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyTyped(KeyEvent keyEvent) {
        Object object = this.keyLock;
        synchronized (object) {
            this.keysTyped.addFirst(Character.valueOf(keyEvent.getKeyChar()));
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public static void main(String[] stringArray) {
        Draw draw = new Draw("Test client 1");
        draw.square(0.2, 0.8, 0.1);
        draw.filledSquare(0.8, 0.8, 0.2);
        draw.circle(0.8, 0.2, 0.2);
        draw.setPenColor(MAGENTA);
        draw.setPenRadius(0.02);
        draw.arc(0.8, 0.2, 0.1, 200.0, 45.0);
        Draw draw2 = new Draw("Test client 2");
        draw2.setCanvasSize(900, 200);
        draw2.setPenRadius();
        draw2.setPenColor(BLUE);
        double[] dArray = new double[]{0.1, 0.2, 0.3, 0.2};
        double[] dArray2 = new double[]{0.2, 0.3, 0.2, 0.1};
        draw2.filledPolygon(dArray, dArray2);
        draw2.setPenColor(BLACK);
        draw2.text(0.2, 0.5, "black text");
        draw2.setPenColor(WHITE);
        draw2.text(0.8, 0.8, "white text");
    }
}

