/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedOutputStream;
import java.io.IOException;

public final class BinaryStdOut {
    private static BufferedOutputStream out = new BufferedOutputStream(System.out);
    private static int buffer;
    private static int N;

    private BinaryStdOut() {
    }

    private static void writeBit(boolean bl) {
        buffer <<= 1;
        if (bl) {
            buffer |= 1;
        }
        if (++N == 8) {
            BinaryStdOut.clearBuffer();
        }
    }

    private static void writeByte(int n) {
        assert (n >= 0 && n < 256);
        if (N == 0) {
            try {
                out.write(n);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
        for (int i = 0; i < 8; ++i) {
            boolean bl = (n >>> 8 - i - 1 & 1) == 1;
            BinaryStdOut.writeBit(bl);
        }
    }

    private static void clearBuffer() {
        if (N == 0) {
            return;
        }
        if (N > 0) {
            buffer <<= 8 - N;
        }
        try {
            out.write(buffer);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        N = 0;
        buffer = 0;
    }

    public static void flush() {
        BinaryStdOut.clearBuffer();
        try {
            out.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void close() {
        BinaryStdOut.flush();
        try {
            out.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void write(boolean bl) {
        BinaryStdOut.writeBit(bl);
    }

    public static void write(byte by) {
        BinaryStdOut.writeByte(by & 0xFF);
    }

    public static void write(int n) {
        BinaryStdOut.writeByte(n >>> 24 & 0xFF);
        BinaryStdOut.writeByte(n >>> 16 & 0xFF);
        BinaryStdOut.writeByte(n >>> 8 & 0xFF);
        BinaryStdOut.writeByte(n >>> 0 & 0xFF);
    }

    public static void write(int n, int n2) {
        if (n2 == 32) {
            BinaryStdOut.write(n);
        }
        if (n2 < 1 || n2 > 32) {
            throw new RuntimeException("Illegal value for r = " + n2);
        }
        if (n < 0 || n >= 1 << n2) {
            throw new RuntimeException("Illegal " + n2 + "-bit char = " + n);
        }
        for (int i = 0; i < n2; ++i) {
            boolean bl = (n >>> n2 - i - 1 & 1) == 1;
            BinaryStdOut.writeBit(bl);
        }
    }

    public static void write(double d) {
        BinaryStdOut.write(Double.doubleToRawLongBits(d));
    }

    public static void write(long l) {
        BinaryStdOut.writeByte((int)(l >>> 56 & 0xFFL));
        BinaryStdOut.writeByte((int)(l >>> 48 & 0xFFL));
        BinaryStdOut.writeByte((int)(l >>> 40 & 0xFFL));
        BinaryStdOut.writeByte((int)(l >>> 32 & 0xFFL));
        BinaryStdOut.writeByte((int)(l >>> 24 & 0xFFL));
        BinaryStdOut.writeByte((int)(l >>> 16 & 0xFFL));
        BinaryStdOut.writeByte((int)(l >>> 8 & 0xFFL));
        BinaryStdOut.writeByte((int)(l >>> 0 & 0xFFL));
    }

    public static void write(float f) {
        BinaryStdOut.write(Float.floatToRawIntBits(f));
    }

    public static void write(short s) {
        BinaryStdOut.writeByte(s >>> 8 & 0xFF);
        BinaryStdOut.writeByte(s >>> 0 & 0xFF);
    }

    public static void write(char c) {
        if (c < '\u0000' || c >= '\u0100') {
            throw new RuntimeException("Illegal 8-bit char = " + c);
        }
        BinaryStdOut.writeByte(c);
    }

    public static void write(char c, int n) {
        if (n == 8) {
            BinaryStdOut.write(c);
        }
        if (n < 1 || n > 16) {
            throw new RuntimeException("Illegal value for r = " + n);
        }
        if (c < '\u0000' || c >= 1 << n) {
            throw new RuntimeException("Illegal " + n + "-bit char = " + c);
        }
        for (int i = 0; i < n; ++i) {
            boolean bl = (c >>> n - i - 1 & 1) == 1;
            BinaryStdOut.writeBit(bl);
        }
    }

    public static void write(String string) {
        for (int i = 0; i < string.length(); ++i) {
            BinaryStdOut.write(string.charAt(i));
        }
    }

    public static void write(String string, int n) {
        for (int i = 0; i < string.length(); ++i) {
            BinaryStdOut.write(string.charAt(i), n);
        }
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        for (int i = 0; i < n; ++i) {
            BinaryStdOut.write(i);
        }
        BinaryStdOut.flush();
    }
}

