/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.IOException;

public class BinaryStdIn {
    private static BufferedInputStream in = new BufferedInputStream(System.in);
    private static final int EOF = -1;
    private static int buffer;
    private static int N;

    private BinaryStdIn() {
    }

    private static void fillBuffer() {
        try {
            buffer = in.read();
            N = 8;
        }
        catch (IOException iOException) {
            System.out.println("EOF");
            buffer = -1;
            N = -1;
        }
    }

    public static void close() {
        try {
            in.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Could not close BinaryStdIn");
        }
    }

    public static boolean isEmpty() {
        return buffer == -1;
    }

    public static boolean readBoolean() {
        boolean bl;
        if (BinaryStdIn.isEmpty()) {
            throw new RuntimeException("Reading from empty input stream");
        }
        boolean bl2 = bl = (buffer >> --N & 1) == 1;
        if (N == 0) {
            BinaryStdIn.fillBuffer();
        }
        return bl;
    }

    public static char readChar() {
        if (BinaryStdIn.isEmpty()) {
            throw new RuntimeException("Reading from empty input stream");
        }
        if (N == 8) {
            int n = buffer;
            BinaryStdIn.fillBuffer();
            return (char)(n & 0xFF);
        }
        int n = buffer;
        n <<= 8 - N;
        int n2 = N;
        BinaryStdIn.fillBuffer();
        if (BinaryStdIn.isEmpty()) {
            throw new RuntimeException("Reading from empty input stream");
        }
        N = n2;
        return (char)((n |= buffer >>> N) & 0xFF);
    }

    public static char readChar(int n) {
        if (n < 1 || n > 16) {
            throw new RuntimeException("Illegal value of r = " + n);
        }
        if (n == 8) {
            return BinaryStdIn.readChar();
        }
        char c = '\u0000';
        for (int i = 0; i < n; ++i) {
            c = (char)(c << 1);
            boolean bl = BinaryStdIn.readBoolean();
            if (!bl) continue;
            c = (char)(c | '\u0001');
        }
        return c;
    }

    public static String readString() {
        if (BinaryStdIn.isEmpty()) {
            throw new RuntimeException("Reading from empty input stream");
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (!BinaryStdIn.isEmpty()) {
            char c = BinaryStdIn.readChar();
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static short readShort() {
        short s = 0;
        for (int i = 0; i < 2; ++i) {
            char c = BinaryStdIn.readChar();
            s = (short)(s << 8);
            s = (short)(s | c);
        }
        return s;
    }

    public static int readInt() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            char c = BinaryStdIn.readChar();
            n <<= 8;
            n |= c;
        }
        return n;
    }

    public static int readInt(int n) {
        if (n < 1 || n > 32) {
            throw new RuntimeException("Illegal value of r = " + n);
        }
        if (n == 32) {
            return BinaryStdIn.readInt();
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 <<= 1;
            boolean bl = BinaryStdIn.readBoolean();
            if (!bl) continue;
            n2 |= 1;
        }
        return n2;
    }

    public static long readLong() {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            char c = BinaryStdIn.readChar();
            l <<= 8;
            l |= (long)c;
        }
        return l;
    }

    public static double readDouble() {
        return Double.longBitsToDouble(BinaryStdIn.readLong());
    }

    public static float readFloat() {
        return Float.intBitsToFloat(BinaryStdIn.readInt());
    }

    public static byte readByte() {
        char c = BinaryStdIn.readChar();
        byte by = (byte)(c & 0xFF);
        return by;
    }

    public static void main(String[] stringArray) {
        while (!BinaryStdIn.isEmpty()) {
            char c = BinaryStdIn.readChar();
            BinaryStdOut.write(c);
        }
        BinaryStdOut.flush();
    }

    static {
        BinaryStdIn.fillBuffer();
    }
}

