/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

public final class BinaryOut {
    private BufferedOutputStream out;
    private int buffer;
    private int N;

    public BinaryOut(OutputStream outputStream) {
        this.out = new BufferedOutputStream(outputStream);
    }

    public BinaryOut() {
        this(System.out);
    }

    public BinaryOut(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            this.out = new BufferedOutputStream(fileOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public BinaryOut(Socket socket) {
        try {
            OutputStream outputStream = socket.getOutputStream();
            this.out = new BufferedOutputStream(outputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeBit(boolean bl) {
        this.buffer <<= 1;
        if (bl) {
            this.buffer |= 1;
        }
        ++this.N;
        if (this.N == 8) {
            this.clearBuffer();
        }
    }

    private void writeByte(int n) {
        assert (n >= 0 && n < 256);
        if (this.N == 0) {
            try {
                this.out.write(n);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
        for (int i = 0; i < 8; ++i) {
            boolean bl = (n >>> 8 - i - 1 & 1) == 1;
            this.writeBit(bl);
        }
    }

    private void clearBuffer() {
        if (this.N == 0) {
            return;
        }
        if (this.N > 0) {
            this.buffer <<= 8 - this.N;
        }
        try {
            this.out.write(this.buffer);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.N = 0;
        this.buffer = 0;
    }

    public void flush() {
        this.clearBuffer();
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void close() {
        this.flush();
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void write(boolean bl) {
        this.writeBit(bl);
    }

    public void write(byte by) {
        this.writeByte(by & 0xFF);
    }

    public void write(int n) {
        this.writeByte(n >>> 24 & 0xFF);
        this.writeByte(n >>> 16 & 0xFF);
        this.writeByte(n >>> 8 & 0xFF);
        this.writeByte(n >>> 0 & 0xFF);
    }

    public void write(int n, int n2) {
        if (n2 == 32) {
            this.write(n);
        }
        if (n2 < 1 || n2 > 32) {
            throw new RuntimeException("Illegal value for r = " + n2);
        }
        if (n < 0 || n >= 1 << n2) {
            throw new RuntimeException("Illegal " + n2 + "-bit char = " + n);
        }
        for (int i = 0; i < n2; ++i) {
            boolean bl = (n >>> n2 - i - 1 & 1) == 1;
            this.writeBit(bl);
        }
    }

    public void write(double d) {
        this.write(Double.doubleToRawLongBits(d));
    }

    public void write(long l) {
        this.writeByte((int)(l >>> 56 & 0xFFL));
        this.writeByte((int)(l >>> 48 & 0xFFL));
        this.writeByte((int)(l >>> 40 & 0xFFL));
        this.writeByte((int)(l >>> 32 & 0xFFL));
        this.writeByte((int)(l >>> 24 & 0xFFL));
        this.writeByte((int)(l >>> 16 & 0xFFL));
        this.writeByte((int)(l >>> 8 & 0xFFL));
        this.writeByte((int)(l >>> 0 & 0xFFL));
    }

    public void write(float f) {
        this.write(Float.floatToRawIntBits(f));
    }

    public void write(short s) {
        this.writeByte(s >>> 8 & 0xFF);
        this.writeByte(s >>> 0 & 0xFF);
    }

    public void write(char c) {
        if (c < '\u0000' || c >= '\u0100') {
            throw new RuntimeException("Illegal 8-bit char = " + c);
        }
        this.writeByte(c);
    }

    public void write(char c, int n) {
        if (n == 8) {
            this.write(c);
        }
        if (n < 1 || n > 16) {
            throw new RuntimeException("Illegal value for r = " + n);
        }
        if (c < '\u0000' || c >= 1 << n) {
            throw new RuntimeException("Illegal " + n + "-bit char = " + c);
        }
        for (int i = 0; i < n; ++i) {
            boolean bl = (c >>> n - i - 1 & 1) == 1;
            this.writeBit(bl);
        }
    }

    public void write(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.write(string.charAt(i));
        }
    }

    public void write(String string, int n) {
        for (int i = 0; i < string.length(); ++i) {
            this.write(string.charAt(i), n);
        }
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        BinaryOut binaryOut = new BinaryOut(string);
        BinaryIn binaryIn = new BinaryIn();
        while (!binaryIn.isEmpty()) {
            char c = binaryIn.readChar();
            binaryOut.write(c);
        }
        binaryOut.flush();
    }
}

