/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;

public final class BinaryIn {
    private BufferedInputStream in;
    private final int EOF = -1;
    private int buffer;
    private int N;

    private void fillBuffer() {
        try {
            this.buffer = this.in.read();
            this.N = 8;
        }
        catch (IOException iOException) {
            System.err.println("EOF");
            this.buffer = -1;
            this.N = -1;
        }
    }

    public BinaryIn() {
        this.in = new BufferedInputStream(System.in);
        this.fillBuffer();
    }

    public BinaryIn(InputStream inputStream) {
        this.in = new BufferedInputStream(inputStream);
        this.fillBuffer();
    }

    public BinaryIn(Socket socket) {
        try {
            InputStream inputStream = socket.getInputStream();
            this.in = new BufferedInputStream(inputStream);
            this.fillBuffer();
        }
        catch (IOException iOException) {
            System.err.println("Could not open " + socket);
        }
    }

    public BinaryIn(URL uRL) {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            this.in = new BufferedInputStream(inputStream);
            this.fillBuffer();
        }
        catch (IOException iOException) {
            System.err.println("Could not open " + uRL);
        }
    }

    public BinaryIn(String string) {
        try {
            File file = new File(string);
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                this.in = new BufferedInputStream(fileInputStream);
                this.fillBuffer();
                return;
            }
            URL uRL = this.getClass().getResource(string);
            if (uRL == null) {
                uRL = new URL(string);
            }
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            this.in = new BufferedInputStream(inputStream);
            this.fillBuffer();
        }
        catch (IOException iOException) {
            System.err.println("Could not open " + string);
        }
    }

    public boolean exists() {
        return this.in != null;
    }

    public boolean isEmpty() {
        return this.buffer == -1;
    }

    public boolean readBoolean() {
        boolean bl;
        if (this.isEmpty()) {
            throw new RuntimeException("Reading from empty input stream");
        }
        --this.N;
        boolean bl2 = bl = (this.buffer >> this.N & 1) == 1;
        if (this.N == 0) {
            this.fillBuffer();
        }
        return bl;
    }

    public char readChar() {
        if (this.isEmpty()) {
            throw new RuntimeException("Reading from empty input stream");
        }
        if (this.N == 8) {
            int n = this.buffer;
            this.fillBuffer();
            return (char)(n & 0xFF);
        }
        int n = this.buffer;
        n <<= 8 - this.N;
        int n2 = this.N;
        this.fillBuffer();
        if (this.isEmpty()) {
            throw new RuntimeException("Reading from empty input stream");
        }
        this.N = n2;
        return (char)((n |= this.buffer >>> this.N) & 0xFF);
    }

    public char readChar(int n) {
        if (n < 1 || n > 16) {
            throw new RuntimeException("Illegal value of r = " + n);
        }
        if (n == 8) {
            return this.readChar();
        }
        char c = '\u0000';
        for (int i = 0; i < n; ++i) {
            c = (char)(c << 1);
            boolean bl = this.readBoolean();
            if (!bl) continue;
            c = (char)(c | '\u0001');
        }
        return c;
    }

    public String readString() {
        if (this.isEmpty()) {
            throw new RuntimeException("Reading from empty input stream");
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (!this.isEmpty()) {
            char c = this.readChar();
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public short readShort() {
        short s = 0;
        for (int i = 0; i < 2; ++i) {
            char c = this.readChar();
            s = (short)(s << 8);
            s = (short)(s | c);
        }
        return s;
    }

    public int readInt() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            char c = this.readChar();
            n <<= 8;
            n |= c;
        }
        return n;
    }

    public int readInt(int n) {
        if (n < 1 || n > 32) {
            throw new RuntimeException("Illegal value of r = " + n);
        }
        if (n == 32) {
            return this.readInt();
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 <<= 1;
            boolean bl = this.readBoolean();
            if (!bl) continue;
            n2 |= 1;
        }
        return n2;
    }

    public long readLong() {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            char c = this.readChar();
            l <<= 8;
            l |= (long)c;
        }
        return l;
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public byte readByte() {
        char c = this.readChar();
        byte by = (byte)(c & 0xFF);
        return by;
    }

    public static void main(String[] stringArray) {
        BinaryIn binaryIn = new BinaryIn(stringArray[0]);
        BinaryOut binaryOut = new BinaryOut(stringArray[1]);
        while (!binaryIn.isEmpty()) {
            char c = binaryIn.readChar();
            binaryOut.write(c);
        }
        binaryOut.flush();
    }
}

